/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.gen;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import noobanidus.mods.lootr.gen.LootrAtlasGenerator;
import noobanidus.mods.lootr.gen.LootrBlockTagProvider;
import noobanidus.mods.lootr.gen.LootrItemTagsProvider;
import noobanidus.mods.lootr.gen.LootrLootTableProvider;

@Mod.EventBusSubscriber(modid="lootr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LootrDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        LootrBlockTagProvider blocks = new LootrBlockTagProvider(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blocks);
        generator.addProvider(event.includeServer(), (DataProvider)new LootrItemTagsProvider(output, provider, blocks.contentsGetter(), helper));
        generator.addProvider(event.includeClient(), (DataProvider)new LootrAtlasGenerator(output, provider, helper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Resources for Lootr"), DetectedVersion.BUILT_IN.getPackVersion(PackType.CLIENT_RESOURCES), Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))));
        generator.addProvider(true, (DataProvider)LootrLootTableProvider.create(output));
    }
}

