/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.ConfigurationPayloadContext;
import net.neoforged.neoforge.network.handling.IConfigurationPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IDirectionAwarePayloadHandlerBuilder;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import noobanidus.mods.lootr.network.ILootrPacket;
import org.jetbrains.annotations.NotNull;

public abstract class BasePacketHandler {
    protected BasePacketHandler(IEventBus modEventBus, String modid, String version) {
        modEventBus.addListener(RegisterPayloadHandlerEvent.class, event -> {
            IPayloadRegistrar registrar = event.registrar(modid).versioned(version);
            this.registerClientToServer(new PacketRegistrar(registrar, IDirectionAwarePayloadHandlerBuilder::server));
            this.registerServerToClient(new PacketRegistrar(registrar, IDirectionAwarePayloadHandlerBuilder::client));
        });
    }

    protected abstract void registerClientToServer(PacketRegistrar var1);

    protected abstract void registerServerToClient(PacketRegistrar var1);

    protected record PacketRegistrar(IPayloadRegistrar registrar, ContextAwareHandler contextAwareHandler) {
        private <MSG extends ILootrPacket<IPayloadContext>> void common(ResourceLocation id, FriendlyByteBuf.Reader<MSG> reader, IPayloadHandler<MSG> handler) {
            this.registrar.common(id, reader, builder -> this.contextAwareHandler.accept(builder, handler));
        }

        public <MSG extends ILootrPacket<IPayloadContext>> void common(ResourceLocation id, FriendlyByteBuf.Reader<MSG> reader) {
            this.common(id, reader, ILootrPacket::handleMainThread);
        }

        public <MSG extends ILootrPacket<IPayloadContext>> void commonNetworkThread(ResourceLocation id, FriendlyByteBuf.Reader<MSG> reader) {
            this.common(id, reader, ILootrPacket::handle);
        }

        public ILootrPacket<IPayloadContext> commonInstanced(ResourceLocation id, Consumer<IPayloadContext> handler) {
            return this.instanced(id, handler, this::common);
        }

        private <MSG extends ILootrPacket<ConfigurationPayloadContext>> void configuration(ResourceLocation id, FriendlyByteBuf.Reader<MSG> reader, IConfigurationPayloadHandler<MSG> handler) {
            this.registrar.configuration(id, reader, builder -> this.contextAwareHandler.accept(builder, handler));
        }

        public void configuration(ResourceLocation id, FriendlyByteBuf.Reader<? extends ILootrPacket<ConfigurationPayloadContext>> reader) {
            this.configuration(id, reader, ILootrPacket::handleMainThread);
        }

        public void configurationNetworkThread(ResourceLocation id, FriendlyByteBuf.Reader<? extends ILootrPacket<ConfigurationPayloadContext>> reader) {
            this.configuration(id, reader, ILootrPacket::handle);
        }

        public ILootrPacket<ConfigurationPayloadContext> configurationInstanced(ResourceLocation id, Consumer<ConfigurationPayloadContext> handler) {
            return this.instanced(id, handler, this::configuration);
        }

        private <MSG extends ILootrPacket<PlayPayloadContext>> void play(ResourceLocation id, FriendlyByteBuf.Reader<MSG> reader, IPlayPayloadHandler<MSG> handler) {
            this.registrar.play(id, reader, builder -> this.contextAwareHandler.accept(builder, handler));
        }

        public void play(ResourceLocation id, FriendlyByteBuf.Reader<? extends ILootrPacket<PlayPayloadContext>> reader) {
            this.play(id, reader, ILootrPacket::handleMainThread);
        }

        public void playNetworkThread(ResourceLocation id, FriendlyByteBuf.Reader<? extends ILootrPacket<PlayPayloadContext>> reader) {
            this.play(id, reader, ILootrPacket::handle);
        }

        public ILootrPacket<PlayPayloadContext> playInstanced(ResourceLocation id, Consumer<PlayPayloadContext> handler) {
            return this.instanced(id, handler, this::play);
        }

        private <CONTEXT extends IPayloadContext> ILootrPacket<CONTEXT> instanced(final ResourceLocation id, final Consumer<CONTEXT> handler, BiConsumer<ResourceLocation, FriendlyByteBuf.Reader<ILootrPacket<CONTEXT>>> registerMethod) {
            ILootrPacket instance = new ILootrPacket<CONTEXT>(){

                public void write(@NotNull FriendlyByteBuf buf) {
                }

                @NotNull
                public ResourceLocation id() {
                    return id;
                }

                @Override
                public void handle(CONTEXT context) {
                    handler.accept(context);
                }
            };
            registerMethod.accept(id, buf -> instance);
            return instance;
        }
    }

    @FunctionalInterface
    private static interface ContextAwareHandler {
        public <PAYLOAD extends CustomPacketPayload, HANDLER> IDirectionAwarePayloadHandlerBuilder<PAYLOAD, HANDLER> accept(IDirectionAwarePayloadHandlerBuilder<PAYLOAD, HANDLER> var1, HANDLER var2);
    }
}

