/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.network;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class PacketUtils {
    private PacketUtils() {
    }

    public static Optional<ServerPlayer> asServerPlayer(IPayloadContext context) {
        return context.player().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast);
    }

    public static <MSG extends CustomPacketPayload> void sendTo(MSG message, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAll(MSG message) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllIfLoaded(MSG message) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketUtils.sendToAll(message);
        }
    }

    public static <MSG extends CustomPacketPayload> void sendToDimension(MSG message, ResourceKey<Level> dimension) {
        PacketDistributor.DIMENSION.with(dimension).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToServer(MSG message) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, Entity entity) {
        PacketDistributor.TRACKING_ENTITY.with((Object)entity).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTrackingAndSelf(MSG message, Entity entity) {
        PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity).send(new CustomPacketPayload[]{message});
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, BlockEntity tile) {
        PacketUtils.sendToAllTracking(message, tile.getLevel(), tile.getBlockPos());
    }

    public static <MSG extends CustomPacketPayload> void sendToAllTracking(MSG message, Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false).forEach(p -> PacketUtils.sendTo(message, p));
        } else {
            PacketDistributor.TRACKING_CHUNK.with((Object)world.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()))).send(new CustomPacketPayload[]{message});
        }
    }

    private static boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return player.getChunkTrackingView().contains(chunkX, chunkZ) && !player.connection.chunkSender.isPending(ChunkPos.asLong((int)chunkX, (int)chunkZ));
    }
}

