/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.network.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ClientHandlers {
    public static void handleCloseCart(int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as level is null.");
            return;
        }
        Entity cart = level.getEntity(entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as closed as entity is not a Lootr minecart.");
            return;
        }
        LootrChestMinecartEntity lootrCart = (LootrChestMinecartEntity)cart;
        lootrCart.setClosed();
    }

    public static void handleOpenCart(int entityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as level is null.");
            return;
        }
        Entity cart = level.getEntity(entityId);
        if (cart == null) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as entity is null.");
            return;
        }
        if (!(cart instanceof LootrChestMinecartEntity)) {
            LootrAPI.LOG.info("Unable to mark entity with id '" + entityId + "' as opened as entity is not a Lootr minecart.");
            return;
        }
        LootrChestMinecartEntity lootrCart = (LootrChestMinecartEntity)cart;
        lootrCart.setOpened();
    }

    public static void handleOpenContainer(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark container open for location '" + pos + "' as level is null.");
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            LootrAPI.LOG.info("Unable to mark container open for location '" + pos + "' as player is null.");
            return;
        }
        SectionPos sPos = SectionPos.of((BlockPos)pos);
        Minecraft.getInstance().levelRenderer.setSectionDirty(sPos.x(), sPos.y(), sPos.z());
    }

    public static void handleCloseContainer(BlockPos pos) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            LootrAPI.LOG.info("Unable to mark container closed for location '" + pos + "' as level is null.");
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            LootrAPI.LOG.info("Unable to mark container closed for location '" + pos + "' as player is null.");
            return;
        }
        SectionPos sPos = SectionPos.of((BlockPos)pos);
        Minecraft.getInstance().levelRenderer.setSectionDirty(sPos.x(), sPos.y(), sPos.z());
    }
}

