/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import noobanidus.mods.lootr.advancement.ContainerTrigger;
import noobanidus.mods.lootr.advancement.LootedStatTrigger;
import noobanidus.mods.lootr.api.IHasOpeners;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.entities.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.DataStorage;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModAdvancements;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.network.PacketUtils;
import noobanidus.mods.lootr.network.to_client.PacketCloseCart;
import noobanidus.mods.lootr.network.to_client.PacketCloseContainer;

public class ChestUtil {
    public static void handleLootSneak(Block block, Level level, BlockPos pos, Player player) {
        ILootBlockEntity tile;
        if (level.isClientSide() || player.isSpectator()) {
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ILootBlockEntity && (tile = (ILootBlockEntity)te).getOpeners().remove(player.getUUID())) {
            te.setChanged();
            tile.updatePacketViaForce(te);
            PacketUtils.sendTo(new PacketCloseContainer(te.getBlockPos()), (ServerPlayer)player);
        }
    }

    public static void handleLootCartSneak(Level level, LootrChestMinecartEntity cart, Player player) {
        if (level.isClientSide() || player.isSpectator()) {
            return;
        }
        cart.getOpeners().remove(player.getUUID());
        PacketUtils.sendToAllTracking(new PacketCloseCart(cart.getId()), (Entity)cart);
    }

    public static Style getInvalidStyle() {
        return (Boolean)ConfigManager.DISABLE_MESSAGE_STYLES.get() != false ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)).withBold(Boolean.valueOf(true));
    }

    public static Style getDecayStyle() {
        return (Boolean)ConfigManager.DISABLE_MESSAGE_STYLES.get() != false ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.RED)).withBold(Boolean.valueOf(true));
    }

    public static Style getRefreshStyle() {
        return (Boolean)ConfigManager.DISABLE_MESSAGE_STYLES.get() != false ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.BLUE)).withBold(Boolean.valueOf(true));
    }

    public static Component getInvalidTable(ResourceLocation lootTable) {
        return Component.translatable((String)"lootr.message.invalid_table", (Object[])new Object[]{lootTable.getNamespace(), lootTable.toString()}).setStyle((Boolean)ConfigManager.DISABLE_MESSAGE_STYLES.get() != false ? Style.EMPTY : Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.DARK_RED)).withBold(Boolean.valueOf(true)));
    }

    public static void handleLootChest(Block block, Level level, BlockPos pos, Player player) {
        if (level.isClientSide() || player.isSpectator()) {
            if (player.isSpectator()) {
                player.openMenu(null);
            }
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof ILootBlockEntity) {
            int refreshValue;
            ILootBlockEntity tile = (ILootBlockEntity)te;
            UUID tileId = tile.getTileId();
            if (tileId == null) {
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.invalid_block").setStyle(ChestUtil.getInvalidStyle()), true);
                return;
            }
            if (DataStorage.isDecayed(tileId)) {
                level.destroyBlock(pos, true);
                ChestUtil.notifyDecay(player, tileId);
                return;
            }
            int decayValue = DataStorage.getDecayValue(tileId);
            if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).setStyle(ChestUtil.getDecayStyle()), true);
            } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, tile)) {
                ChestUtil.startDecay(player, tileId, decayValue);
            }
            ContainerTrigger trigger = (ContainerTrigger)((Object)ModAdvancements.CHEST.get());
            if (block instanceof BarrelBlock) {
                trigger = (ContainerTrigger)((Object)ModAdvancements.BARREL.get());
            } else if (block instanceof LootrShulkerBlock) {
                trigger = (ContainerTrigger)((Object)ModAdvancements.SHULKER.get());
            }
            trigger.trigger((ServerPlayer)player, tileId);
            if (DataStorage.isRefreshed(tileId)) {
                DataStorage.refreshInventory(level, pos, tileId, (ServerPlayer)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).setStyle(ChestUtil.getRefreshStyle()), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tileId, pos, (ServerPlayer)player, (RandomizableContainerBlockEntity)te, tile::unpackLootTable);
            if (provider == null) {
                return;
            }
            ChestUtil.checkScore((ServerPlayer)player, tileId);
            if (ChestUtil.addOpener(tile, player)) {
                te.setChanged();
                tile.updatePacketViaState();
            }
            player.openMenu((MenuProvider)provider);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    private static boolean addOpener(IHasOpeners openable, Player player) {
        return openable.getOpeners().add(player.getUUID());
    }

    public static void handleLootCart(Level level, LootrChestMinecartEntity cart, Player player) {
        int refreshValue;
        if (level.isClientSide() || player.isSpectator()) {
            if (player.isSpectator()) {
                player.openMenu(null);
            }
            return;
        }
        ((ContainerTrigger)((Object)ModAdvancements.CART.get())).trigger((ServerPlayer)player, cart.getUUID());
        UUID tileId = cart.getUUID();
        if (DataStorage.isDecayed(tileId)) {
            cart.destroy(cart.damageSources().fellOutOfWorld());
            ChestUtil.notifyDecay(player, tileId);
            return;
        }
        int decayValue = DataStorage.getDecayValue(tileId);
        if (decayValue > 0 && ConfigManager.shouldNotify(decayValue)) {
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decay_in", (Object[])new Object[]{decayValue / 20}).setStyle(ChestUtil.getDecayStyle()), true);
        } else if (decayValue == -1 && ConfigManager.isDecaying((ServerLevel)level, cart)) {
            ChestUtil.startDecay(player, tileId, decayValue);
        }
        ChestUtil.addOpener(cart, player);
        ChestUtil.checkScore((ServerPlayer)player, cart.getUUID());
        if (DataStorage.isRefreshed(tileId)) {
            DataStorage.refreshInventory(level, cart, (ServerPlayer)player);
            ChestUtil.notifyRefresh(player, tileId);
        }
        if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).setStyle(ChestUtil.getRefreshStyle()), true);
        } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, cart)) {
            ChestUtil.startRefresh(player, tileId, refreshValue);
        }
        SpecialChestInventory provider = DataStorage.getInventory(level, cart, (ServerPlayer)player, cart::addLoot);
        if (provider == null) {
            return;
        }
        player.openMenu((MenuProvider)provider);
    }

    public static void handleLootInventory(Block block, Level level, BlockPos pos, Player player) {
        if (level.isClientSide() || player.isSpectator()) {
            if (player.isSpectator()) {
                player.openMenu(null);
            }
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (te instanceof LootrInventoryBlockEntity) {
            int refreshValue;
            UUID tileId;
            LootrInventoryBlockEntity tile = (LootrInventoryBlockEntity)te;
            ((ContainerTrigger)((Object)ModAdvancements.CHEST.get())).trigger((ServerPlayer)player, tile.getTileId());
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            if (DataStorage.isRefreshed(tileId = tile.getTileId())) {
                DataStorage.refreshInventory(level, pos, tile.getTileId(), stacks, (ServerPlayer)player);
                ChestUtil.notifyRefresh(player, tileId);
            }
            if ((refreshValue = DataStorage.getRefreshValue(tileId)) > 0 && ConfigManager.shouldNotify(refreshValue)) {
                player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_in", (Object[])new Object[]{refreshValue / 20}).setStyle(ChestUtil.getRefreshStyle()), true);
            } else if (refreshValue == -1 && ConfigManager.isRefreshing((ServerLevel)level, tile)) {
                ChestUtil.startRefresh(player, tileId, refreshValue);
            }
            SpecialChestInventory provider = DataStorage.getInventory(level, tile.getTileId(), stacks, (ServerPlayer)player, pos, (RandomizableContainerBlockEntity)tile);
            if (provider == null) {
                return;
            }
            ChestUtil.checkScore((ServerPlayer)player, tile.getTileId());
            if (ChestUtil.addOpener(tile, player)) {
                te.setChanged();
                tile.updatePacketViaState();
            }
            player.openMenu((MenuProvider)provider);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.withSize((int)reference.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).copy());
        }
        return contents;
    }

    private static void checkScore(ServerPlayer player, UUID tileId) {
        if (!DataStorage.isScored(player.getUUID(), tileId)) {
            player.awardStat(ModStats.LOOTED_STAT);
            ((LootedStatTrigger)((Object)ModAdvancements.STAT.get())).trigger(player);
            DataStorage.score(player.getUUID(), tileId);
        }
    }

    private static void notifyDecay(Player player, UUID tileId) {
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decayed").setStyle(ChestUtil.getDecayStyle()), true);
        DataStorage.removeDecayed(tileId);
    }

    private static void notifyRefresh(Player player, UUID tileId) {
        DataStorage.removeRefreshed(tileId);
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refreshed").setStyle(ChestUtil.getRefreshStyle()), true);
    }

    private static void startDecay(Player player, UUID tileId, int decayValue) {
        DataStorage.setDecaying(tileId, (Integer)ConfigManager.DECAY_VALUE.get());
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.decay_start", (Object[])new Object[]{(Integer)ConfigManager.DECAY_VALUE.get() / 20}).setStyle(ChestUtil.getDecayStyle()), true);
    }

    private static void startRefresh(Player player, UUID tileId, int refreshValue) {
        DataStorage.setRefreshing(tileId, (Integer)ConfigManager.REFRESH_VALUE.get());
        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.refresh_start", (Object[])new Object[]{(Integer)ConfigManager.REFRESH_VALUE.get() / 20}).setStyle(ChestUtil.getRefreshStyle()), true);
    }
}

