/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.StructurePlacement;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class SimpleStructure
extends Structure {
    public static final Codec<SimpleStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.CODEC.forGetter(s -> s.modifiableStructureInfo().getOriginalStructureInfo().structureSettings()), (App)Codec.either((Codec)StructurePoolElement.CODEC, (Codec)StructureTemplatePool.CODEC).fieldOf("template").forGetter(s -> s.structure), (App)StructurePlacement.CODEC.fieldOf("placement").forGetter(s -> s.placement)).apply((Applicative)instance, SimpleStructure::new));
    private final Either<StructurePoolElement, Holder<StructureTemplatePool>> structure;
    private final StructurePlacement placement;

    public SimpleStructure(Structure.StructureSettings settings, Either<StructurePoolElement, Holder<StructureTemplatePool>> structure, StructurePlacement placement) {
        super(settings);
        this.structure = structure;
        this.placement = placement;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        StructurePoolElement element = (StructurePoolElement)this.structure.map(Function.identity(), holder -> ((StructureTemplatePool)holder.value()).getRandomTemplate((RandomSource)context.random()));
        if (element == EmptyPoolElement.INSTANCE) {
            return Optional.empty();
        }
        int x = context.chunkPos().getBlockX(context.random().nextInt(16));
        int z = context.chunkPos().getBlockZ(context.random().nextInt(16));
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BoundingBox boundingBox = element.getBoundingBox(context.structureTemplateManager(), new BlockPos(x, 0, z), rotation);
        Optional<Integer> height = this.placement.findHeight(context, boundingBox);
        return height.map(y -> y - element.getGroundLevelDelta() + 1).filter(y -> y >= context.heightAccessor().getMinBuildHeight()).map(y -> new Structure.GenerationStub(new BlockPos(x, y.intValue(), z), piecesBuilder -> piecesBuilder.addPiece((StructurePiece)new PoolElementStructurePiece(context.structureTemplateManager(), element, new BlockPos(x, y.intValue(), z), element.getGroundLevelDelta(), rotation, boundingBox.move(0, y.intValue(), 0)))));
    }

    public StructureType<?> type() {
        return (StructureType)FormationsStructures.SIMPLE_STRUCTURE.get();
    }
}

