/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class ChiseledBookshelfProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("slotFillChance", (Object)Float.valueOf(0.4f)).forGetter(p -> Float.valueOf(p.slotFillChance))).apply((Applicative)instance, ChiseledBookshelfProcessor::new));
    private final float slotFillChance;

    public ChiseledBookshelfProcessor(float slotFillChance) {
        this.slotFillChance = slotFillChance;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState state = block.state();
        if (state != null && state.is(Blocks.CHISELED_BOOKSHELF)) {
            NonNullList books = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
            if (block.nbt() != null) {
                ContainerHelper.loadAllItems((CompoundTag)block.nbt(), (NonNullList)books);
            }
            RandomSource random = placeSettings.getRandom(pos);
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)books.get(i)).isEmpty() || !(random.nextFloat() < this.slotFillChance)) continue;
                Enchantment enchantment = (Enchantment)((Holder.Reference)BuiltInRegistries.ENCHANTMENT.getRandom(random).get()).value();
                ItemStack book = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(enchantment, random.nextInt(enchantment.getMaxLevel()) + 1));
                books.set(i, (Object)book);
                state = (BlockState)state.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i), (Comparable)Boolean.valueOf(true));
            }
            CompoundTag nbt = block.nbt() == null ? new CompoundTag() : block.nbt().copy();
            ContainerHelper.saveAllItems((CompoundTag)nbt, (NonNullList)books, (boolean)true);
            return new BlockInstance(state, nbt);
        }
        return block;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.CHISELED_BOOKSHELF_PROCESSOR.get();
    }
}

