/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class RespawnAnchorProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<RespawnAnchorProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)4).optionalFieldOf("minCharges", (Object)0).forGetter(p -> p.minCharges), (App)Codec.intRange((int)0, (int)4).optionalFieldOf("maxCharges", (Object)4).forGetter(p -> p.maxCharges)).apply((Applicative)instance, RespawnAnchorProcessor::new)).comapFlatMap(processor -> {
        if (processor.minCharges > processor.maxCharges) {
            return DataResult.error(() -> "Max charges must be greater than or equal to min charges, minCharges: " + processor.minCharges + ", maxCharges: " + processor.maxCharges);
        }
        return DataResult.success((Object)processor);
    }, Function.identity());
    private final int minCharges;
    private final int maxCharges;

    public RespawnAnchorProcessor(int minCharges, int maxCharges) {
        this.minCharges = minCharges;
        this.maxCharges = maxCharges;
    }

    public RespawnAnchorProcessor() {
        this(0, 4);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        if (block.state() != null && block.state().is(Blocks.RESPAWN_ANCHOR)) {
            int charges = this.minCharges + placeSettings.getRandom(pos).nextInt(this.maxCharges - this.minCharges);
            return new BlockInstance((BlockState)block.state().setValue((Property)RespawnAnchorBlock.CHARGE, (Comparable)Integer.valueOf(charges)), block.nbt());
        }
        return block;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.RESPAWN_ANCHOR_PROCESSOR.get();
    }
}

