/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class WaterloggingProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<WaterloggingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WaterHandling.CODEC.optionalFieldOf("handling", (Object)WaterHandling.TAKE_STRUCTURE).forGetter(p -> p.waterHandling)).apply((Applicative)instance, WaterloggingProcessor::new));
    private final WaterHandling waterHandling;

    public WaterloggingProcessor(WaterHandling waterHandling) {
        this.waterHandling = waterHandling;
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState state = block.state();
        if (state != null && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            boolean structureWaterlogged;
            boolean waterlogged = (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED);
            if (this.waterHandling == WaterHandling.DRY) {
                return waterlogged ? new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), block.nbt()) : block;
            }
            if (this.waterHandling == WaterHandling.WET) {
                return waterlogged ? block : new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), block.nbt());
            }
            BlockState structureState = pieceBlocks.get(pos).state();
            boolean bl = structureWaterlogged = structureState != null && structureState.getFluidState().is((Fluid)Fluids.WATER);
            if (this.waterHandling == WaterHandling.TAKE_STRUCTURE) {
                return waterlogged == structureWaterlogged ? block : new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(structureWaterlogged)), block.nbt());
            }
            boolean worldWaterlogged = level.getFluidState(pos).is((Fluid)Fluids.WATER);
            if (this.waterHandling == WaterHandling.TAKE_WORLD) {
                return waterlogged == worldWaterlogged ? block : new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(worldWaterlogged)), block.nbt());
            }
            if (this.waterHandling == WaterHandling.WORLD_OR_STRUCTURE_WET) {
                return waterlogged == (worldWaterlogged || structureWaterlogged) ? block : new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(worldWaterlogged || structureWaterlogged)), block.nbt());
            }
            if (this.waterHandling == WaterHandling.WORLD_OR_STRUCTURE_DRY) {
                return waterlogged == (worldWaterlogged && structureWaterlogged) ? block : new BlockInstance((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(worldWaterlogged && structureWaterlogged)), block.nbt());
            }
        }
        return block;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)FormationsStructures.WATERLOGGING_PROCESSOR.get();
    }

    public static enum WaterHandling implements StringRepresentable
    {
        DRY,
        WET,
        TAKE_WORLD,
        TAKE_STRUCTURE,
        WORLD_OR_STRUCTURE_WET,
        WORLD_OR_STRUCTURE_DRY;

        static final Codec<WaterHandling> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(WaterHandling::values);
        }
    }
}

