/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.loot_table;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.FormationsLevelData;
import com.supermartijn642.formations.tools.loot_table.OpenLootTableScreenPacket;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.neoforged.neoforge.common.NeoForge;

public class ContainerOpenIntercept {
    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(event -> {
            Player player = event.getEntity();
            Level world = event.getLevel();
            if (player.isSpectator() || world.isClientSide || !FormationsLevelData.SERVER.isDevMode()) {
                return;
            }
            if (player.isShiftKeyDown() && (player.getMainHandItem().getItem() instanceof BlockItem || player.getOffhandItem().getItem() instanceof BlockItem)) {
                return;
            }
            BlockEntity entity = world.getBlockEntity(event.getPos());
            if (entity instanceof RandomizableContainerBlockEntity && (!player.isShiftKeyDown() || ((RandomizableContainerBlockEntity)entity).lootTable != null)) {
                FormationsDev.CHANNEL.sendToPlayer(player, (BasePacket)new OpenLootTableScreenPacket(entity.getBlockPos(), ((RandomizableContainerBlockEntity)entity).lootTable));
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.FAIL);
            }
        });
    }
}

