/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.loot_table;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.loot_table.SetLootTablePacket;
import com.supermartijn642.formations.tools.template.screen.TemplateEditButton;
import java.util.Objects;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class LootTableEditingScreen
extends BaseWidget {
    private static final ResourceLocation SCREEN_BACKGROUND = Formations.location("textures/gui/loot_table_editing_screen.png");
    private final BlockPos pos;
    private final ResourceLocation original;
    private TemplateEditButton saveButton;

    public LootTableEditingScreen(BlockPos pos, ResourceLocation originalLootTable) {
        super(0, 0, 200, 66);
        this.pos = pos;
        this.original = originalLootTable;
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"formations.edit_loot.title").get();
    }

    protected void addWidgets() {
        TextFieldWidget lootTableField = new TextFieldWidget(8, 32, 184, 12, this.original == null ? "" : this.original.toString(), 100, t -> {
            this.saveButton.active = t.isBlank() || RegistryUtil.isValidIdentifier((String)t.trim());
        });
        lootTableField.setSuggestion(I18n.get((String)"formations.edit_loot.loot_table_hint", (Object[])new Object[0]));
        this.addWidget((Widget)lootTableField);
        this.addWidget((Widget)new TemplateEditButton(0, 51, 72, 15, (Component)TextComponents.translation((String)"formations.edit_loot.cancel").get(), TemplateEditButton.LEFT_BUTTON, () -> ClientUtils.getMinecraft().setScreen(null)));
        this.saveButton = (TemplateEditButton)this.addWidget((Widget)new TemplateEditButton(128, 51, 72, 15, (Component)TextComponents.translation((String)"formations.edit_loot.save").get(), TemplateEditButton.GREEN_RIGHT_BUTTON, () -> {
            String lootTableText = lootTableField.getText().trim();
            if (lootTableText.isEmpty() || RegistryUtil.isValidIdentifier((String)lootTableText)) {
                ResourceLocation lootTable;
                ResourceLocation resourceLocation = lootTable = lootTableText.isEmpty() ? null : new ResourceLocation(lootTableText);
                if (!Objects.equals(lootTable, this.original)) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new SetLootTablePacket(this.pos, lootTable));
                }
                ClientUtils.getMinecraft().setScreen(null);
            }
        }));
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((ResourceLocation)SCREEN_BACKGROUND);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.left(), (float)this.top(), (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        super.renderBackground(context, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        super.renderForeground(context, mouseX, mouseY);
        ScreenUtils.drawCenteredStringWithShadow((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.edit_loot.title").get(), (float)100.0f, (float)3.0f, (int)0xE0E0E0);
        ScreenUtils.drawCenteredString((PoseStack)context.poseStack(), (Component)TextComponents.translation((String)"formations.edit_loot.loot_table_hint").get(), (float)35.0f, (float)22.0f);
    }
}

