/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.loot_table;

import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class SetLootTablePacket
implements BasePacket {
    private BlockPos pos;
    private ResourceLocation lootTable;

    public SetLootTablePacket(BlockPos pos, ResourceLocation lootTable) {
        this.pos = pos;
        this.lootTable = lootTable;
    }

    public SetLootTablePacket() {
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeBoolean(this.lootTable != null);
        if (this.lootTable != null) {
            buffer.writeResourceLocation(this.lootTable);
        }
    }

    public void read(FriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.lootTable = buffer.readBoolean() ? buffer.readResourceLocation() : null;
    }

    public void handle(PacketContext context) {
        BlockEntity entity;
        if (context.getHandlingSide() == CoreSide.SERVER && context.getSendingPlayer().blockPosition().distManhattan((Vec3i)this.pos) <= 32 && (entity = context.getWorld().getBlockEntity(this.pos)) instanceof RandomizableContainerBlockEntity) {
            Clearable.tryClear((Object)entity);
            ((RandomizableContainerBlockEntity)entity).setLootTable(this.lootTable, 0L);
            entity.setChanged();
        }
    }
}

