/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyBindings.class);
    private static final KeyConflictContextGadget CONFLICT_CONTEXT_GADGET = new KeyConflictContextGadget();
    private static final List<KeyMapping> keyMappings = new ArrayList<KeyMapping>();
    public static KeyMapping menuSettings = KeyBindings.createBinding("settings_menu", 71);
    public static KeyMapping undo = KeyBindings.createBinding("undo", 85);
    public static KeyMapping anchor = KeyBindings.createBinding("anchor", 72);
    public static KeyMapping range = KeyBindings.createBinding("range", 82);

    private static KeyMapping createBinding(String name, int key) {
        KeyMapping keyBinding = new KeyMapping(KeyBindings.getKey(name), (IKeyConflictContext)CONFLICT_CONTEXT_GADGET, InputConstants.Type.KEYSYM.getOrCreate(key), KeyBindings.getKey("category"));
        keyMappings.add(keyBinding);
        return keyBinding;
    }

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        LOGGER.debug("Registering {} keybinding for {}", (Object)keyMappings.size(), (Object)"buildinggadgets2");
        keyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    private static String getKey(String name) {
        return String.join((CharSequence)".", "key", "buildinggadgets2", name);
    }

    public static void onClientInput(InputEvent.Key event) {
    }

    public static class KeyConflictContextGadget
    implements IKeyConflictContext {
        public boolean isActive() {
            LocalPlayer player = Minecraft.getInstance().player;
            return !KeyConflictContext.GUI.isActive() && player != null && !BaseGadget.getGadget((Player)player).isEmpty();
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    }
}

