/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.particles.fluidparticle;

import com.direwolf20.buildinggadgets2.client.particles.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidFlowParticleData
implements ParticleOptions {
    private final FluidStack fluidStack;
    public final boolean doGravity;
    public final boolean shrinking;
    public static final ParticleOptions.Deserializer<FluidFlowParticleData> DESERIALIZER = new ParticleOptions.Deserializer<FluidFlowParticleData>(){

        @Nonnull
        public FluidFlowParticleData fromCommand(ParticleType<FluidFlowParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            ItemParser.ItemResult itemparser$itemresult = ItemParser.parseForItem((HolderLookup)BuiltInRegistries.ITEM.asLookup(), (StringReader)reader);
            ItemStack itemstack = new ItemInput(itemparser$itemresult.item(), itemparser$itemresult.nbt()).createItemStack(1, false);
            reader.expect(' ');
            boolean doGravity = reader.readBoolean();
            reader.expect(' ');
            boolean building = reader.readBoolean();
            return new FluidFlowParticleData(FluidStack.EMPTY, doGravity, building);
        }

        public FluidFlowParticleData fromNetwork(ParticleType<FluidFlowParticleData> particleTypeIn, FriendlyByteBuf buffer) {
            return new FluidFlowParticleData(buffer.readFluidStack(), buffer.readBoolean(), buffer.readBoolean());
        }
    };

    public FluidFlowParticleData(FluidStack fluidStack, boolean doGravity, boolean shrinking) {
        this.fluidStack = fluidStack.copy();
        this.doGravity = doGravity;
        this.shrinking = shrinking;
    }

    @Nonnull
    public ParticleType<FluidFlowParticleData> getType() {
        return ModParticles.FLUIDFLOWPARTICLE.get();
    }

    public void writeToNetwork(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.fluidStack);
    }

    @Nonnull
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %b %b", this.getType(), this.doGravity, this.shrinking);
    }

    @OnlyIn(value=Dist.CLIENT)
    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

