/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class DireVertexConsumerSquished
extends VertexConsumerWrapper {
    private final float minX;
    private final float minY;
    private final float minZ;
    private final float maxX;
    private final float maxY;
    private final float maxZ;
    private final Matrix4f matrix4f;
    float minU = 0.0f;
    float maxU = 1.0f;
    float minV = 0.0f;
    float maxV = 1.0f;
    public boolean adjustUV = false;
    public boolean bottomUp = false;
    Direction direction = null;
    TextureAtlasSprite sprite;
    private float red = -1.0f;
    private float green = -1.0f;
    private float blue = -1.0f;

    public DireVertexConsumerSquished(VertexConsumer parent, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Matrix4f matrix4f) {
        super(parent);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.matrix4f = matrix4f;
    }

    public DireVertexConsumerSquished(VertexConsumer parent, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Matrix4f matrix4f, float red, float green, float blue) {
        super(parent);
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.matrix4f = matrix4f;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public VertexConsumer color(int r, int g, int b, int a) {
        if (this.red == -1.0f) {
            this.parent.color(r, g, b, a);
        } else {
            int rCol = (int)Mth.lerp((float)this.red, (float)0.0f, (float)r);
            int gCol = (int)Mth.lerp((float)this.green, (float)0.0f, (float)g);
            int bCol = (int)Mth.lerp((float)this.blue, (float)0.0f, (float)b);
            this.parent.color(rCol, gCol, bCol, a);
        }
        return this;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        this.minU = sprite.getU0();
        this.maxU = sprite.getU1();
        this.minV = sprite.getV0();
        this.maxV = sprite.getV1();
    }

    public VertexConsumer vertex(double x, double y, double z) {
        Matrix4f inverseMatrix = new Matrix4f((Matrix4fc)this.matrix4f);
        inverseMatrix.invert();
        Vector4f originalVector = inverseMatrix.transform(new Vector4f((float)x, (float)y, (float)z, 1.0f));
        float adjustedX = originalVector.x * (this.maxX - this.minX) + this.minX;
        float adjustedY = originalVector.y * (this.maxY - this.minY) + this.minY;
        float adjustedZ = originalVector.z * (this.maxZ - this.minZ) + this.minZ;
        Vector4f vector4f = this.matrix4f.transform(new Vector4f(adjustedX, adjustedY, adjustedZ, 1.0f));
        this.parent.vertex((double)vector4f.x, (double)vector4f.y, (double)vector4f.z);
        return this;
    }

    public VertexConsumer uv(float u, float v) {
        if (this.adjustUV) {
            if (this.bottomUp) {
                if (this.direction != null && !this.direction.getAxis().equals((Object)Direction.Axis.Y)) {
                    float uDistanceFromStart = u - this.minU;
                    float vDistanceFromStart = v - this.minV;
                    float adjustedUDistance = uDistanceFromStart;
                    float adjustedVDistance = vDistanceFromStart * this.maxY;
                    float adjustedU = this.minU + adjustedUDistance;
                    float adjustedV = this.minV + adjustedVDistance;
                    this.parent.uv(adjustedU, adjustedV);
                } else {
                    this.parent.uv(u, v);
                }
            } else if (this.direction != null && !this.direction.getAxis().equals((Object)Direction.Axis.Y)) {
                float uDistanceToEnd = this.maxU - u;
                float vDistanceToEnd = this.maxV - v;
                float adjustedUDistance = uDistanceToEnd;
                float adjustedVDistance = vDistanceToEnd * this.maxY;
                float adjustedU = this.maxU - adjustedUDistance;
                float adjustedV = this.maxV - adjustedVDistance;
                this.parent.uv(adjustedU, adjustedV);
            } else {
                this.parent.uv(u, v);
            }
        } else {
            this.parent.uv(u, v);
        }
        return this;
    }
}

