/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumer;
import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumerSquished;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MyRenderMethods {
    private static Map<BlockEntityType<?>, BlockEntityRenderer<?>> renderers = ImmutableMap.of();

    public static void renderBETransparent(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MultiplyAlphaRenderTypeBuffer(pBufferSource, alpha);
        ItemStack stack = new ItemStack((ItemLike)pState.getBlock());
        IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderBESquished(BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float alpha) {
        SquishedRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new SquishedRenderTypeBuffer(pBufferSource, alpha, pPoseStack.last().pose());
        ItemStack stack = new ItemStack((ItemLike)pState.getBlock());
        IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, pPoseStack, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, pPackedLight, pPackedOverlay);
    }

    public static void renderCopy(PoseStack matrix, BlockPos startPos, BlockPos endPos, Color color) {
        if (startPos.equals((Object)GadgetNBT.nullPos) || endPos.equals((Object)GadgetNBT.nullPos)) {
            return;
        }
        int x = Math.min(startPos.getX(), endPos.getX());
        int y = Math.min(startPos.getY(), endPos.getY());
        int z = Math.min(startPos.getZ(), endPos.getZ());
        int dx = startPos.getX() > endPos.getX() ? startPos.getX() + 1 : endPos.getX() + 1;
        int dy = startPos.getY() > endPos.getY() ? startPos.getY() + 1 : endPos.getY() + 1;
        int dz = startPos.getZ() > endPos.getZ() ? startPos.getZ() + 1 : endPos.getZ() + 1;
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(OurRenderTypes.lines());
        matrix.pushPose();
        Matrix4f matrix4f = matrix.last().pose();
        Matrix3f matrix3f = matrix.last().normal();
        int colorRGB = color.getRGB();
        builder.vertex(matrix4f, (float)x, (float)y, (float)z).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)z).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)y, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)y, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)z).color(colorRGB).normal(matrix3f, -1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)z).color(colorRGB).normal(matrix3f, -1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, -1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, -1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, -1.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, -1.0f).endVertex();
        builder.vertex(matrix4f, (float)x, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 1.0f, 0.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)y, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 1.0f, 0.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)z).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        builder.vertex(matrix4f, (float)dx, (float)dy, (float)dz).color(colorRGB).normal(matrix3f, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.endBatch(OurRenderTypes.lines());
        matrix.popPose();
    }

    public static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, BlockPos pos, float r, float g, float b, float alpha) {
        double x = (double)pos.getX() - 0.001;
        double y = (double)pos.getY() - 0.001;
        double z = (double)pos.getZ() - 0.001;
        double xEnd = (double)pos.getX() + 1.0015;
        double yEnd = (double)pos.getY() + 1.0015;
        double zEnd = (double)pos.getZ() + 1.0015;
        MyRenderMethods.renderBoxSolid(matrix, builder, x, y, z, xEnd, yEnd, zEnd, r, g, b, alpha);
    }

    protected static void renderBoxSolid(Matrix4f matrix, VertexConsumer builder, double x, double y, double z, double xEnd, double yEnd, double zEnd, float red, float green, float blue, float alpha) {
        float startX = (float)x;
        float startY = (float)y;
        float startZ = (float)z;
        float endX = (float)xEnd;
        float endY = (float)yEnd;
        float endZ = (float)zEnd;
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, endX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, startZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, startY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, endZ).color(red, green, blue, alpha).endVertex();
        builder.vertex(matrix, startX, endY, startZ).color(red, green, blue, alpha).endVertex();
    }

    public static class MultiplyAlphaRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float constantAlpha;

        public MultiplyAlphaRenderTypeBuffer(MultiBufferSource inner, float constantAlpha) {
            this.inner = inner;
            this.constantAlpha = constantAlpha;
        }

        public VertexConsumer getBuffer(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).state.textureState).texture.orElse(InventoryMenu.BLOCK_ATLAS);
                localType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.translucentCullBlockSheet().toString())) {
                localType = Sheets.translucentCullBlockSheet();
            }
            return new DireVertexConsumer(this.inner.getBuffer(localType), this.constantAlpha);
        }
    }

    public static class SquishedRenderTypeBuffer
    implements MultiBufferSource {
        private final MultiBufferSource inner;
        private final float squishAmt;
        private final Matrix4f matrix4f;

        public SquishedRenderTypeBuffer(MultiBufferSource inner, float squishAmt, Matrix4f matrix4f) {
            this.inner = inner;
            this.squishAmt = squishAmt;
            this.matrix4f = matrix4f;
        }

        public VertexConsumer getBuffer(RenderType type) {
            RenderType localType = type;
            if (localType instanceof RenderType.CompositeRenderType) {
                ResourceLocation texture = ((RenderStateShard.TextureStateShard)((RenderType.CompositeRenderType)localType).state.textureState).texture.orElse(InventoryMenu.BLOCK_ATLAS);
                localType = RenderType.entityTranslucentCull((ResourceLocation)texture);
            } else if (localType.toString().equals(Sheets.translucentCullBlockSheet().toString())) {
                localType = Sheets.translucentCullBlockSheet();
            }
            return new DireVertexConsumerSquished(this.inner.getBuffer(localType), 0.0f, 0.0f, 0.0f, 1.0f, this.squishAmt, 1.0f, this.matrix4f);
        }
    }
}

