/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.client.renderer.DireBufferBuilder;
import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumer;
import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.RenderFluidBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2DataClient;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class VBORenderer {
    private static ArrayList<StatePos> statePosCache;
    private static int sortCounter;
    public static UUID copyPasteUUIDCache;
    private static FakeRenderingWorld fakeRenderingWorld;
    private static final Map<RenderType, BufferBuilder.SortState> sortStates;
    private static final Map<RenderType, DireBufferBuilder> builders;
    private static final Map<RenderType, VertexBuffer> vertexBuffers;

    public static DireBufferBuilder getBuffer(RenderType renderType) {
        DireBufferBuilder buffer = builders.get(renderType);
        if (!buffer.building()) {
            buffer.begin(renderType.mode(), renderType.format());
        }
        return buffer;
    }

    public static void clearBuffers() {
        for (Map.Entry<RenderType, VertexBuffer> entry : vertexBuffers.entrySet()) {
            entry.getValue().close();
        }
    }

    public static void buildRender(RenderLevelStageEvent evt, Player player, ItemStack gadget) {
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.getBlockPos() : anchorPos;
        BaseMode mode = GadgetNBT.getMode(gadget);
        DimBlockPos boundTo = GadgetNBT.getBoundPos(gadget);
        if (boundTo != null && boundTo.levelKey.equals((Object)player.level().dimension())) {
            VBORenderer.drawBoundBox(evt.getPoseStack(), boundTo.blockPos);
        }
        if (gadget.getItem() instanceof GadgetCopyPaste || gadget.getItem() instanceof GadgetCutPaste) {
            renderPos = renderPos.above();
            renderPos.offset((Vec3i)GadgetNBT.getRelativePaste(gadget));
            if (mode.getId().getPath().equals("copy") || mode.getId().getPath().equals("cut")) {
                VBORenderer.drawCopyBox(evt.getPoseStack(), gadget, mode.getId().getPath());
                return;
            }
        }
        if (VBORenderer.shouldUpdateRender(player, gadget)) {
            VBORenderer.generateRender(player.level(), renderPos, gadget, 0.5f, statePosCache, vertexBuffers);
        }
    }

    public static boolean shouldUpdateRender(Player player, ItemStack gadget) {
        BaseMode mode = GadgetNBT.getMode(gadget);
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.getBlockPos() : anchorPos;
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (gadget.getItem() instanceof GadgetBuilding || gadget.getItem() instanceof GadgetExchanger) {
            if (player.level().getBlockState(renderPos).isAir()) {
                return false;
            }
            BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
            if (renderBlockState.isAir()) {
                return false;
            }
            ArrayList<StatePos> buildList = mode.collect(lookingAt.getDirection(), player, renderPos, renderBlockState);
            FakeRenderingWorld tempWorld = new FakeRenderingWorld(player.level(), buildList, renderPos);
            if (fakeRenderingWorld != null && VBORenderer.fakeRenderingWorld.positions.equals(tempWorld.positions)) {
                return false;
            }
            statePosCache = buildList;
            copyPasteUUIDCache = UUID.randomUUID();
            return true;
        }
        if (gadget.getItem() instanceof GadgetCopyPaste || gadget.getItem() instanceof GadgetCutPaste) {
            renderPos = renderPos.above();
            renderPos.offset((Vec3i)GadgetNBT.getRelativePaste(gadget));
            if (mode.getId().getPath().equals("paste")) {
                if (!BG2DataClient.isClientUpToDate(gadget)) {
                    return false;
                }
                UUID BG2ClientUUID = BG2DataClient.getCopyUUID(gadgetUUID);
                if (BG2ClientUUID != null && copyPasteUUIDCache.equals(BG2ClientUUID)) {
                    return false;
                }
                copyPasteUUIDCache = BG2ClientUUID;
                statePosCache = BG2DataClient.getLookupFromUUID(gadgetUUID);
                return true;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void generateRender(Level level, BlockPos renderPos, ItemStack gadget, float transparency, ArrayList<StatePos> statePosCache, Map<RenderType, VertexBuffer> vertexBuffers) {
        boolean isExchanging;
        boolean bl = isExchanging = gadget.getItem() instanceof BaseGadget && GadgetNBT.getMode((ItemStack)gadget).isExchanging;
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        fakeRenderingWorld = new FakeRenderingWorld(level, statePosCache, renderPos);
        PoseStack matrix = new PoseStack();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer modelBlockRenderer = dispatcher.getModelRenderer();
        RandomSource random = RandomSource.create();
        for (StatePos pos2 : statePosCache.stream().filter(pos -> VBORenderer.isModelRender(pos.state) || !pos.state.getFluidState().isEmpty()).toList()) {
            BlockState renderState = fakeRenderingWorld.getBlockStateWithoutReal(pos2.pos);
            if (renderState.isAir()) continue;
            BakedModel ibakedmodel = dispatcher.getBlockModel(renderState);
            matrix.pushPose();
            matrix.translate((float)pos2.pos.getX(), (float)pos2.pos.getY(), (float)pos2.pos.getZ());
            if (isExchanging) {
                matrix.translate(-5.0E-4f, -5.0E-4f, -5.0E-4f);
                matrix.scale(1.001f, 1.001f, 1.001f);
            }
            for (RenderType renderType : ibakedmodel.getRenderTypes(renderState, random, ModelData.EMPTY)) {
                if (renderType.equals(RenderType.cutout()) && renderState.getShape((BlockGetter)level, pos2.pos.offset((Vec3i)renderPos)).equals(Shapes.block())) {
                    renderType = RenderType.translucent();
                }
                DireVertexConsumer direVertexConsumer = new DireVertexConsumer((VertexConsumer)VBORenderer.getBuffer(renderType), transparency);
                if (renderState.getFluidState().isEmpty()) {
                    try {
                        modelBlockRenderer.tesselateBlock((BlockAndTintGetter)fakeRenderingWorld, ibakedmodel, renderState, pos2.pos.offset((Vec3i)renderPos).above(255), matrix, (VertexConsumer)direVertexConsumer, false, random, renderState.getSeed(pos2.pos.offset((Vec3i)renderPos)), OverlayTexture.NO_OVERLAY, ibakedmodel.getModelData((BlockAndTintGetter)fakeRenderingWorld, pos2.pos, renderState, ModelData.EMPTY), renderType);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                RenderFluidBlock.renderFluidBlock(renderState, level, pos2.pos.offset((Vec3i)renderPos).above(255), matrix, (VertexConsumer)direVertexConsumer, false);
            }
            matrix.popPose();
        }
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 subtracted = projectedView.subtract((double)renderPos.getX(), (double)renderPos.getY(), (double)renderPos.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        for (Map.Entry<RenderType, DireBufferBuilder> entry : builders.entrySet()) {
            RenderType renderType;
            renderType = entry.getKey();
            DireBufferBuilder direBufferBuilder = VBORenderer.getBuffer(renderType);
            direBufferBuilder.setQuadSorting(VertexSorting.byDistance((Vector3f)sortPos));
            sortStates.put(renderType, direBufferBuilder.getSortState());
            VertexBuffer vertexBuffer = vertexBuffers.get(entry.getKey());
            vertexBuffer.bind();
            vertexBuffer.upload(direBufferBuilder.end());
            VertexBuffer.unbind();
        }
    }

    public static void drawCopyBox(PoseStack matrix, ItemStack gadget, String mode) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrix.pushPose();
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        BlockPos start = GadgetNBT.getCopyStartPos(gadget);
        BlockPos end = GadgetNBT.getCopyEndPos(gadget);
        Color color = mode.equals("copy") ? Color.GREEN : Color.RED;
        MyRenderMethods.renderCopy(matrix, start, end, color);
        matrix.popPose();
    }

    public static void drawBoundBox(PoseStack matrix, BlockPos blockPos) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrix.pushPose();
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        Color color = Color.BLUE;
        MyRenderMethods.renderCopy(matrix, blockPos, blockPos, color);
        matrix.popPose();
    }

    public static boolean isModelRender(BlockState state) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = dispatcher.getBlockModel(state);
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.getQuads(state, direction, RandomSource.create(), ModelData.EMPTY, null).isEmpty()) {
                return true;
            }
            if (ibakedmodel.getQuads(state, null, RandomSource.create(), ModelData.EMPTY, null).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void drawRender(RenderLevelStageEvent evt, Player player, ItemStack gadget) {
        if (vertexBuffers == null || statePosCache == null) {
            return;
        }
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        BlockPos anchorPos = GadgetNBT.getAnchorPos(gadget);
        BlockPos renderPos = anchorPos.equals((Object)GadgetNBT.nullPos) ? lookingAt.getBlockPos() : anchorPos;
        BlockState lookingAtState = player.level().getBlockState(renderPos);
        if (lookingAtState.isAir() && anchorPos.equals((Object)GadgetNBT.nullPos) || lookingAtState.getBlock().equals(Registration.RenderBlock.get())) {
            return;
        }
        ArrayList<Object> buildList = new ArrayList();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (gadget.getItem() instanceof GadgetBuilding || gadget.getItem() instanceof GadgetExchanger) {
            BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
            if (renderBlockState.isAir()) {
                return;
            }
            buildList = mode.collect(lookingAt.getDirection(), player, renderPos, renderBlockState);
            if (buildList.isEmpty()) {
                return;
            }
        } else if (gadget.getItem() instanceof GadgetCopyPaste || gadget.getItem() instanceof GadgetCutPaste) {
            if (mode.getId().getPath().equals("copy") || mode.getId().getPath().equals("cut")) {
                return;
            }
            if (!GadgetNBT.hasCopyUUID(gadget) || !copyPasteUUIDCache.equals(GadgetNBT.getCopyUUID(gadget))) {
                return;
            }
            renderPos = renderPos.above().offset((Vec3i)GadgetNBT.getRelativePaste(gadget));
        }
        if (sortCounter > 20) {
            VBORenderer.sortAll(renderPos);
            sortCounter = 0;
        } else {
            ++sortCounter;
        }
        PoseStack matrix = evt.getPoseStack();
        matrix.pushPose();
        matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
        matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.solid());
        drawSet.add(RenderType.cutout());
        drawSet.add(RenderType.cutoutMipped());
        drawSet.add(RenderType.translucent());
        drawSet.add(RenderType.tripwire());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.cutout()) ? OurRenderTypes.RenderBlock : RenderType.translucent();
                VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.getFormat() == null) continue;
                drawRenderType.setupRenderState();
                vertexBuffer.bind();
                vertexBuffer.drawWithShader(matrix.last().pose(), new Matrix4f((Matrix4fc)evt.getProjectionMatrix()), RenderSystem.getShader());
                VertexBuffer.unbind();
                drawRenderType.clearRenderState();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.popPose();
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        MyRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MyRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 0.5f);
        fakeRenderingWorld = new FakeRenderingWorld(player.level(), statePosCache, renderPos);
        for (StatePos pos2 : statePosCache.stream().filter(pos -> !VBORenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.isAir()) continue;
            matrix.pushPose();
            matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
            matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
            matrix.translate((float)pos2.pos.getX(), (float)pos2.pos.getY(), (float)pos2.pos.getZ());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            BlockEntity blockEntity = fakeRenderingWorld.getBlockEntity(pos2.pos);
            if (blockEntity != null) {
                blockEntityRenderer.render(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer);
            } else {
                MyRenderMethods.renderBETransparent(fakeRenderingWorld.getBlockState(pos2.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
            }
            matrix.popPose();
        }
        boolean hasBound = GadgetNBT.getBoundPos(gadget) != null;
        BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadget);
        if ((gadget.getItem() instanceof GadgetBuilding || gadget.getItem() instanceof GadgetExchanger) && !player.isCreative() && !hasBound && renderBlockState.getFluidState().isEmpty()) {
            ItemStack findStack = GadgetUtils.getItemForBlock(renderBlockState, player.level(), BlockPos.ZERO, player);
            int availableItems = BuildingUtils.countItemStacks(player, findStack);
            int energyStored = BuildingUtils.getEnergyStored(gadget);
            int energyCost = BuildingUtils.getEnergyCost(gadget);
            for (StatePos statePos : buildList) {
                if (availableItems <= 0 || energyStored < energyCost) {
                    matrix.pushPose();
                    matrix.translate(-projectedView.x(), -projectedView.y(), -projectedView.z());
                    matrix.translate((float)renderPos.getX(), (float)renderPos.getY(), (float)renderPos.getZ());
                    VertexConsumer builder = buffersource.getBuffer(OurRenderTypes.MissingBlockOverlay);
                    MyRenderMethods.renderBoxSolid(evt.getPoseStack().last().pose(), builder, statePos.pos, 1.0f, 0.0f, 0.0f, 0.35f);
                    matrix.popPose();
                }
                --availableItems;
                energyStored -= energyCost;
            }
        }
    }

    public static void sortAll(BlockPos lookingAt) {
        for (Map.Entry<RenderType, BufferBuilder.SortState> entry : sortStates.entrySet()) {
            RenderType renderType = entry.getKey();
            BufferBuilder.RenderedBuffer renderedBuffer = VBORenderer.sort(lookingAt, renderType);
            VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
            vertexBuffer.bind();
            vertexBuffer.upload(renderedBuffer);
            VertexBuffer.unbind();
        }
    }

    public static BufferBuilder.RenderedBuffer sort(BlockPos lookingAt, RenderType renderType) {
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 subtracted = projectedView.subtract((double)lookingAt.getX(), (double)lookingAt.getY(), (double)lookingAt.getZ());
        Vector3f sortPos = new Vector3f((float)subtracted.x, (float)subtracted.y, (float)subtracted.z);
        DireBufferBuilder bufferBuilder = VBORenderer.getBuffer(renderType);
        BufferBuilder.SortState sortState = sortStates.get(renderType);
        bufferBuilder.restoreSortState(sortState);
        bufferBuilder.setQuadSorting(VertexSorting.byDistance((Vector3f)sortPos));
        sortStates.put(renderType, bufferBuilder.getSortState());
        return bufferBuilder.end();
    }

    static {
        sortCounter = 0;
        copyPasteUUIDCache = UUID.randomUUID();
        sortStates = new HashMap<RenderType, BufferBuilder.SortState>();
        builders = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new DireBufferBuilder(type.bufferSize())));
        vertexBuffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    }
}

