/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.screen.widgets.GuiIncrementer;
import com.direwolf20.buildinggadgets2.common.network.data.GadgetActionPayload;
import com.direwolf20.buildinggadgets2.common.network.handler.gadgetaction.ActionGadget;
import com.direwolf20.buildinggadgets2.common.network.handler.gadgetaction.GadgetActionCodecs;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CopyGUI
extends Screen {
    private GuiIncrementer startX;
    private GuiIncrementer startY;
    private GuiIncrementer startZ;
    private GuiIncrementer endX;
    private GuiIncrementer endY;
    private GuiIncrementer endZ;
    private boolean absoluteCoords = false;
    private int x;
    private int y;
    private ItemStack copyPasteTool;
    private BlockPos startPos;
    private BlockPos endPos;
    private Button absoluteButton;
    private List<GuiIncrementer> fields = new ArrayList<GuiIncrementer>();

    public CopyGUI(ItemStack tool) {
        super((Component)Component.literal((String)""));
        this.copyPasteTool = tool;
    }

    public void init() {
        super.init();
        this.fields.clear();
        this.x = this.width / 2;
        this.y = this.height / 2;
        this.startPos = GadgetNBT.getCopyStartPos(this.copyPasteTool);
        this.endPos = GadgetNBT.getCopyEndPos(this.copyPasteTool);
        int incrementerWidth = 96;
        this.startX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 40, this::onChange);
        this.fields.add(this.startX);
        this.startY = new GuiIncrementer(this.x - 32, this.y - 40, this::onChange);
        this.fields.add(this.startY);
        this.startZ = new GuiIncrementer(this.x + 32 + 35, this.y - 40, this::onChange);
        this.fields.add(this.startZ);
        this.endX = new GuiIncrementer(this.x - incrementerWidth - 35, this.y - 15, this::onChange);
        this.fields.add(this.endX);
        this.endY = new GuiIncrementer(this.x - 32, this.y - 15, this::onChange);
        this.fields.add(this.endY);
        this.endZ = new GuiIncrementer(this.x + 32 + 35, this.y - 15, this::onChange);
        this.fields.add(this.endZ);
        this.fields.forEach(x$0 -> {
            GuiIncrementer cfr_ignored_0 = (GuiIncrementer)this.addRenderableWidget((GuiEventListener)x$0);
        });
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>(){
            {
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)Component.translatable((String)"buildinggadgets2.screen.confirm"), button -> {
                    CopyGUI.this.sendPacket();
                    CopyGUI.this.onClose();
                }));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)Component.translatable((String)"buildinggadgets2.screen.close"), button -> CopyGUI.this.onClose()));
                this.add(new CenteredButton(CopyGUI.this.y + 20, 50, (Component)Component.translatable((String)"buildinggadgets2.screen.clear"), button -> {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GadgetActionPayload(ActionGadget.COPY_COORDS, (Tag)GadgetActionCodecs.BiPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new GadgetActionCodecs.BiPos(GadgetNBT.nullPos, GadgetNBT.nullPos)).get().orThrow())});
                    CopyGUI.this.onClose();
                }));
                CopyGUI.this.absoluteButton = new CenteredButton(CopyGUI.this.y + 20, 120, (Component)Component.translatable((String)"buildinggadgets2.screen.absolutecoords"), button -> {
                    CopyGUI.this.coordsModeSwitch();
                    CopyGUI.this.updateTextFields();
                });
                this.add(CopyGUI.this.absoluteButton);
            }
        };
        this.updateTextFields();
        CenteredButton.centerButtonList((List<AbstractButton>)buttons, this.x);
        buttons.forEach(x$0 -> {
            AbstractButton cfr_ignored_0 = (AbstractButton)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    private void drawFieldLabel(GuiGraphics guiGraphics, Component name, int x, int y) {
        guiGraphics.drawString(this.font, name, this.x + x, this.y + y, 0xFFFFFF);
    }

    private void onChange(int value) {
        this.sendPacket();
    }

    private void sendPacket() {
        if (this.absoluteCoords) {
            this.startPos = new BlockPos(this.startX.getValue(), this.startY.getValue(), this.startZ.getValue());
            this.endPos = new BlockPos(this.endX.getValue(), this.endY.getValue(), this.endZ.getValue());
        } else {
            this.startPos = new BlockPos(this.startPos.getX() + this.startX.getValue(), this.startPos.getY() + this.startY.getValue(), this.startPos.getZ() + this.startZ.getValue());
            this.endPos = new BlockPos(this.startPos.getX() + this.endX.getValue(), this.startPos.getY() + this.endY.getValue(), this.startPos.getZ() + this.endZ.getValue());
            this.startX.setValue(0, false);
            this.startY.setValue(0, false);
            this.startZ.setValue(0, false);
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new GadgetActionPayload(ActionGadget.COPY_COORDS, (Tag)GadgetActionCodecs.BiPos.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new GadgetActionCodecs.BiPos(this.startPos, this.endPos)).get().orThrow())});
    }

    private void coordsModeSwitch() {
        this.absoluteCoords = !this.absoluteCoords;
    }

    private void updateTextFields() {
        if (this.absoluteCoords) {
            this.absoluteButton.setMessage((Component)Component.translatable((String)"buildinggadgets2.screen.relativecoords"));
            BlockPos start = this.startX.getValue() != 0 ? new BlockPos(this.startPos.getX() + this.startX.getValue(), this.startPos.getY() + this.startY.getValue(), this.startPos.getZ() + this.startZ.getValue()) : this.startPos;
            BlockPos end = this.endX.getValue() != 0 ? new BlockPos(this.startPos.getX() + this.endX.getValue(), this.startPos.getY() + this.endY.getValue(), this.startPos.getZ() + this.endZ.getValue()) : this.endPos;
            this.startX.setValue(start.getX(), false);
            this.startY.setValue(start.getY(), false);
            this.startZ.setValue(start.getZ(), false);
            this.endX.setValue(end.getX(), false);
            this.endY.setValue(end.getY(), false);
            this.endZ.setValue(end.getZ(), false);
        } else {
            this.absoluteButton.setMessage((Component)Component.translatable((String)"buildinggadgets2.screen.absolutecoords"));
            this.startX.setValue(this.startX.getValue() != 0 ? this.startX.getValue() - this.startPos.getX() : 0, false);
            this.startY.setValue(this.startY.getValue() != 0 ? this.startY.getValue() - this.startPos.getY() : 0, false);
            this.startZ.setValue(this.startZ.getValue() != 0 ? this.startZ.getValue() - this.startPos.getZ() : 0, false);
            this.endX.setValue(this.endX.getValue() != 0 ? this.endX.getValue() - this.startPos.getX() : this.endPos.getX() - this.startPos.getX(), false);
            this.endY.setValue(this.endY.getValue() != 0 ? this.endY.getValue() - this.startPos.getY() : this.endPos.getY() - this.startPos.getY(), false);
            this.endZ.setValue(this.endZ.getValue() != 0 ? this.endZ.getValue() - this.startPos.getZ() : this.endPos.getZ() - this.startPos.getZ(), false);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawFieldLabel(guiGraphics, (Component)Component.translatable((String)"buildinggadgets2.screen.start").append(" X"), -175, -36);
        this.drawFieldLabel(guiGraphics, (Component)Component.literal((String)"Y"), -45, -36);
        this.drawFieldLabel(guiGraphics, (Component)Component.literal((String)"Z"), 55, -36);
        this.drawFieldLabel(guiGraphics, (Component)Component.translatable((String)"buildinggadgets2.screen.end").append(" X"), -167, -11);
        this.drawFieldLabel(guiGraphics, (Component)Component.literal((String)"Y"), -45, -11);
        this.drawFieldLabel(guiGraphics, (Component)Component.literal((String)"Z"), 55, -11);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"buildinggadgets2.screen.copyheading"), this.x, this.y - 80, 0xFFFFFF);
        guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"buildinggadgets2.screen.copysubheading"), this.x, this.y - 68, 0xFFFFFF);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int mouseX, int mouseY, int __unused) {
        this.fields.forEach(button -> button.keyPressed(mouseX, mouseY, __unused));
        return super.keyPressed(mouseX, mouseY, __unused);
    }

    public boolean charTyped(char charTyped, int __unused) {
        this.fields.forEach(button -> button.charTyped(charTyped, __unused));
        return false;
    }

    public boolean isPauseScreen() {
        return false;
    }

    static class CenteredButton
    extends Button {
        CenteredButton(int y, int width, Component text, Button.OnPress onPress) {
            super(CenteredButton.builder((Component)text, (Button.OnPress)onPress).pos(0, y).size(width, 20));
        }

        static void centerButtonList(List<AbstractButton> buttons, int startX) {
            int collectiveWidth = buttons.stream().mapToInt(AbstractWidget::getWidth).sum() + (buttons.size() - 1) * 5;
            int nextX = startX - collectiveWidth / 2;
            for (AbstractButton button : buttons) {
                button.setX(nextX);
                nextX += button.getWidth() + 5;
            }
        }
    }
}

