/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen;

import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.VBORenderer;
import com.direwolf20.buildinggadgets2.client.screen.widgets.ScrollingMaterialList;
import com.direwolf20.buildinggadgets2.common.blockentities.TemplateManagerBE;
import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.Redprint;
import com.direwolf20.buildinggadgets2.common.items.TemplateItem;
import com.direwolf20.buildinggadgets2.common.network.data.SendPastePayload;
import com.direwolf20.buildinggadgets2.common.network.data.UpdateTemplateManagerPayload;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2DataClient;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.Template;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class TemplateManagerGUI
extends AbstractContainerScreen<TemplateManagerContainer> {
    private static final ResourceLocation background = new ResourceLocation("buildinggadgets2", "textures/gui/template_manager.png");
    private final Rect2i panel = new Rect2i(-12, 12, 136, 80);
    private boolean panelClicked;
    private int clickButton;
    private int clickX;
    private int clickY;
    private float initRotX;
    private float initRotY;
    private float initZoom;
    private float initPanX;
    private float initPanY;
    private float momentumX;
    private float momentumY;
    private float rotX = 0.0f;
    private float rotY = 0.0f;
    private float zoom = 1.0f;
    private float panX = 0.0f;
    private float panY = 0.0f;
    private EditBox nameField;
    private Button buttonSave;
    private Button buttonLoad;
    private Button buttonCopy;
    private Button buttonPaste;
    private Button buttonToggleViewport;
    private int renderSlot = 0;
    public static UUID gadgetUUID = UUID.randomUUID();
    public static UUID templateUUID = UUID.randomUUID();
    public static UUID copyPasteUUIDCache = UUID.randomUUID();
    private static ArrayList<StatePos> statePosCache;
    private final TemplateManagerBE be;
    private final TemplateManagerContainer container;
    private ScrollingMaterialList scrollingList;
    private boolean showMaterialList = false;
    private static final Map<RenderType, VertexBuffer> vertexBuffers;

    public TemplateManagerGUI(TemplateManagerContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, (Component)Component.literal((String)""));
        this.container = container;
        this.be = container.getTe();
    }

    public void init() {
        super.init();
        Objects.requireNonNull(this.font);
        this.nameField = new EditBox(this.font, this.leftPos - 20 + 8, this.topPos - 5, this.imageWidth - 16, 9 + 3, (Component)Component.translatable((String)"buildinggadgets2.screen.namefieldtext"));
        this.updateNameField();
        int x = this.leftPos - 20 + 180;
        this.buttonSave = new ExtendedButton(x, this.topPos + 15, 60, 15, (Component)Component.translatable((String)"buildinggadgets2.buttons.save"), button -> this.onSave());
        this.buttonLoad = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"buildinggadgets2.buttons.load"), b -> this.onLoad()).pos(x, this.topPos + 32).size(60, 15).build());
        this.buttonCopy = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"buildinggadgets2.buttons.copy"), b -> this.onCopy()).pos(x, this.topPos + 50).size(60, 15).build());
        this.buttonPaste = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"buildinggadgets2.buttons.paste"), b -> this.onPaste()).pos(x, this.topPos + 67).size(60, 15).build());
        this.buttonToggleViewport = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"buildinggadgets2.buttons.render"), b -> this.onToggleViewport()).pos(x, this.topPos + 85).size(60, 15).build());
        this.renderSlot = 1;
        this.addRenderableWidget((GuiEventListener)this.buttonSave);
        this.nameField.setMaxLength(50);
        this.nameField.setVisible(true);
        this.addRenderableWidget((GuiEventListener)this.nameField);
        this.scrollingList = new ScrollingMaterialList((Screen)this, this.leftPos + this.panel.getX(), this.topPos + this.panel.getY(), this.panel.getWidth(), this.panel.getHeight(), this.container.getSlot(this.renderSlot).getItem());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.updateAsNeeded();
        if (this.showMaterialList) {
            if (!this.renderables.contains((Object)this.scrollingList)) {
                this.addRenderableWidget((GuiEventListener)this.scrollingList);
            }
        } else {
            this.removeWidget((GuiEventListener)this.scrollingList);
            guiGraphics.flush();
            this.renderPanel(guiGraphics);
        }
    }

    public void updateNameField() {
        ItemStack gadgetStack = this.container.getSlot(0).getItem();
        ItemStack templateStack = this.container.getSlot(1).getItem();
        String gadgetName = GadgetNBT.getTemplateName(gadgetStack);
        String templateName = GadgetNBT.getTemplateName(templateStack);
        this.nameField.setValue(templateName.isEmpty() ? gadgetName : templateName);
    }

    public void updateAsNeeded() {
        ItemStack gadgetStack = this.container.getSlot(0).getItem();
        ItemStack templateStack = this.container.getSlot(1).getItem();
        boolean updatePanel = false;
        UUID gadgetStackUUID = GadgetNBT.getUUID(gadgetStack);
        UUID templateStackUUID = GadgetNBT.getUUID(templateStack);
        if (!gadgetStackUUID.equals(gadgetUUID)) {
            gadgetUUID = gadgetStackUUID;
            updatePanel = true;
        }
        if (!templateStackUUID.equals(templateUUID)) {
            templateUUID = templateStackUUID;
            updatePanel = true;
        }
        if (updatePanel) {
            this.updateNameField();
        }
        this.updatePanelIfNeeded();
    }

    public boolean updatePanelIfNeeded() {
        ItemStack gadget = this.container.getSlot(this.renderSlot).getItem();
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (gadget.isEmpty() || !(gadget.getItem() instanceof GadgetCopyPaste) && !(gadget.getItem() instanceof TemplateItem) && !(gadget.getItem() instanceof Redprint) && !(gadget.getItem() instanceof GadgetCutPaste)) {
            copyPasteUUIDCache = UUID.randomUUID();
            this.resetViewport();
            this.scrollingList.setTemplateItem(gadget);
            return false;
        }
        if (!BG2DataClient.isClientUpToDate(gadget)) {
            return false;
        }
        UUID BG2ClientUUID = BG2DataClient.getCopyUUID(gadgetUUID);
        if (BG2ClientUUID != null && copyPasteUUIDCache.equals(BG2ClientUUID)) {
            return false;
        }
        copyPasteUUIDCache = BG2ClientUUID;
        statePosCache = BG2DataClient.getLookupFromUUID(gadgetUUID);
        VBORenderer.generateRender((Level)this.getMinecraft().level, BlockPos.ZERO, gadget, 1.0f, statePosCache, vertexBuffers);
        this.scrollingList.setTemplateItem(gadget);
        return true;
    }

    private void renderPanel(GuiGraphics guiGraphics) {
        double scale = this.getMinecraft().getWindow().getGuiScale();
        ItemStack gadget = this.container.getSlot(this.renderSlot).getItem();
        if (gadget.isEmpty()) {
            return;
        }
        ArrayList<StatePos> statePosCache = BG2DataClient.getLookupFromUUID(GadgetNBT.getUUID(gadget));
        if (statePosCache == null || statePosCache.isEmpty()) {
            return;
        }
        BlockPos startPos = statePosCache.get((int)0).pos;
        BlockPos endPos = statePosCache.get((int)(statePosCache.size() - 1)).pos;
        float lengthX = Math.abs(startPos.getX() - endPos.getX());
        float lengthY = Math.abs(startPos.getY() - endPos.getY());
        float lengthZ = Math.abs(startPos.getZ() - endPos.getZ());
        float maxW = 96.0f;
        float maxH = 176.0f;
        float overW = Math.max(lengthX * 16.0f - 96.0f, lengthZ * 16.0f - 96.0f);
        float overH = lengthY * 16.0f - 176.0f;
        float sc = 1.0f;
        float zoomScale = 1.0f;
        if (overW > 0.0f && overW >= overH) {
            sc = 96.0f / (overW + 96.0f);
            zoomScale = overW / 40.0f;
        } else if (overH > 0.0f && overH >= overW) {
            sc = 176.0f / (overH + 176.0f);
            zoomScale = overH / 40.0f;
        }
        int x1 = (int)Math.round((double)(this.leftPos + this.panel.getX()) * scale);
        int y1 = (int)Math.round((double)this.getMinecraft().getWindow().getHeight() - (double)(this.topPos + this.panel.getY() + this.panel.getHeight()) * scale);
        int x2 = (int)Math.round((double)this.panel.getWidth() * scale);
        int y2 = (int)Math.round((double)this.panel.getHeight() * scale);
        RenderSystem.viewport((int)x1, (int)y1, (int)x2, (int)y2);
        RenderSystem.backupProjectionMatrix();
        float fov = 60.0f;
        float aspectRatio = (float)this.width / (float)this.height;
        float near = 0.1f;
        float far = 1000.0f;
        Matrix4f projectionMatrix = new Matrix4f();
        projectionMatrix.setPerspective((float)Math.toRadians(fov), aspectRatio, near, far);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.pushPose();
        poseStack.setIdentity();
        poseStack.translate(-lengthZ / 2.0f + this.panX, -lengthY / 2.0f - this.panY, -lengthZ + this.zoom);
        poseStack.mulPose(new Quaternionf().setAngleAxis(this.rotX / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.mulPose(new Quaternionf().setAngleAxis(this.rotY / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)256, (boolean)false);
        RenderSystem.runAsFancy(() -> this.drawRenderScreen(poseStack, (Player)Minecraft.getInstance().player, statePosCache));
        poseStack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.viewport((int)0, (int)0, (int)this.getMinecraft().getWindow().getWidth(), (int)this.getMinecraft().getWindow().getHeight());
        RenderSystem.restoreProjectionMatrix();
    }

    public void drawRenderScreen(PoseStack matrix, Player player, ArrayList<StatePos> statePosCache) {
        if (this.container.getSlot(1).getItem().isEmpty()) {
            return;
        }
        MultiBufferSource.BufferSource buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        ArrayList<RenderType> drawSet = new ArrayList<RenderType>();
        drawSet.add(RenderType.solid());
        drawSet.add(RenderType.cutout());
        drawSet.add(RenderType.cutoutMipped());
        drawSet.add(RenderType.translucent());
        drawSet.add(RenderType.tripwire());
        try {
            for (RenderType renderType : drawSet) {
                RenderType drawRenderType = renderType.equals(RenderType.cutout()) ? OurRenderTypes.RenderBlock : RenderType.translucent();
                VertexBuffer vertexBuffer = vertexBuffers.get(renderType);
                if (vertexBuffer.getFormat() == null) continue;
                drawRenderType.setupRenderState();
                vertexBuffer.bind();
                vertexBuffer.drawWithShader(matrix.last().pose(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                VertexBuffer.unbind();
                drawRenderType.clearRenderState();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        matrix.pushPose();
        matrix.setIdentity();
        MyRenderMethods.MultiplyAlphaRenderTypeBuffer multiplyAlphaRenderTypeBuffer = new MyRenderMethods.MultiplyAlphaRenderTypeBuffer((MultiBufferSource)buffersource, 1.0f);
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(player.level(), statePosCache, BlockPos.ZERO);
        for (StatePos pos2 : statePosCache.stream().filter(pos -> !VBORenderer.isModelRender(pos.state)).toList()) {
            if (pos2.state.isAir()) continue;
            matrix.pushPose();
            matrix.translate((float)pos2.pos.getX(), (float)pos2.pos.getY(), (float)pos2.pos.getZ());
            BlockEntityRenderDispatcher blockEntityRenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            BlockEntity blockEntity = fakeRenderingWorld.getBlockEntity(pos2.pos);
            if (blockEntity != null) {
                BlockEntityRenderer renderer = blockEntityRenderer.getRenderer(blockEntity);
                try {
                    renderer.render(blockEntity, 0.0f, matrix, (MultiBufferSource)multiplyAlphaRenderTypeBuffer, 0xF00000, OverlayTexture.NO_OVERLAY);
                }
                catch (Exception exception) {}
            } else {
                try {
                    MyRenderMethods.renderBETransparent(fakeRenderingWorld.getBlockState(pos2.pos), matrix, (MultiBufferSource)buffersource, 0xF00000, 655360, 0.5f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            matrix.popPose();
        }
        matrix.popPose();
        buffersource.endLastBatch();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(background, this.leftPos - 20, this.topPos - 12, 0, 0, this.imageWidth, this.imageHeight + 25);
        guiGraphics.blit(background, this.leftPos - 20 + this.imageWidth, this.topPos + 8, this.imageWidth + 3, 30, 71, this.imageHeight);
        if (!this.buttonCopy.isHovered() && !this.buttonPaste.isHovered()) {
            if (this.buttonLoad.isHovered()) {
                guiGraphics.blit(background, this.leftPos + this.imageWidth - 44, this.topPos + 38, this.imageWidth, 0, 17, 24);
            } else {
                guiGraphics.blit(background, this.leftPos + this.imageWidth - 44, this.topPos + 38, this.imageWidth + 17, 0, 16, 24);
            }
        }
        this.nameField.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void resetViewport() {
        this.rotX = 0.0f;
        this.rotY = 0.0f;
        this.zoom = 1.0f;
        this.momentumX = 0.0f;
        this.momentumY = 0.0f;
        this.panX = 0.0f;
        this.panY = 0.0f;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.panel.contains((int)mouseX - this.leftPos, (int)mouseY - this.topPos)) {
            if (this.showMaterialList) {
                this.setFocused((GuiEventListener)this.scrollingList);
            } else {
                this.clickButton = mouseButton;
                this.panelClicked = true;
                this.clickX = (int)this.getMinecraft().mouseHandler.xpos();
                this.clickY = (int)this.getMinecraft().mouseHandler.ypos();
            }
        }
        if (!this.panel.contains((int)mouseX - this.leftPos, (int)mouseY - this.topPos)) {
            this.scrollingList.setSelected(null);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int state) {
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initPanX = this.panX;
        this.initPanY = this.panY;
        this.initZoom = this.zoom;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public boolean mouseDragged(double x, double y, int button, double dx, double dy) {
        if (this.showMaterialList) {
            return this.getFocused() != null && this.isDragging() && button == 0 ? this.getFocused().mouseDragged(x, y, button, dx, dy) : false;
        }
        return super.mouseDragged(x, y, button, dx, dy);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.onClose();
            return true;
        }
        return this.nameField.isFocused() ? this.nameField.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                float prevRotX = this.rotX;
                float prevRotY = this.rotY;
                this.rotX = this.initRotX - (float)((int)this.getMinecraft().mouseHandler.ypos() - this.clickY);
                this.rotY = this.initRotY + (float)((int)this.getMinecraft().mouseHandler.xpos() - this.clickX);
            } else if (this.clickButton == 1) {
                this.panX = this.initPanX + (float)((int)this.getMinecraft().mouseHandler.xpos() - this.clickX) / 8.0f;
                this.panY = this.initPanY + (float)((int)this.getMinecraft().mouseHandler.ypos() - this.clickY) / 8.0f;
            } else if (this.clickButton == 2) {
                this.resetViewport();
            }
        }
        this.rotX += this.momentumX;
        this.rotY += this.momentumY;
        float momentumDampening = 0.98f;
        this.momentumX *= momentumDampening;
        this.momentumY *= momentumDampening;
        if (!this.nameField.isFocused() && this.nameField.getValue().isEmpty()) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"buildinggadgets2.screen.templateplaceholder"), this.nameField.getX() - this.leftPos + 4, this.nameField.getY() + 2 - this.topPos, -10197916);
        }
        if (this.buttonSave.isHovered() || this.buttonLoad.isHovered() || this.buttonPaste.isHovered()) {
            this.drawSlotOverlay(guiGraphics, this.buttonLoad.isHovered() ? this.container.getSlot(0) : this.container.getSlot(1));
        }
    }

    private void drawSlotOverlay(GuiGraphics guiGraphics, Slot slot) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 1000.0f);
        guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, -1660903937);
        guiGraphics.pose().popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseDeltaX, double mouseDeltaY) {
        this.zoom = this.initZoom + (float)mouseDeltaY * 2.0f;
        if (this.zoom < -200.0f) {
            this.zoom = -200.0f;
        }
        if (this.zoom > 5000.0f) {
            this.zoom = 5000.0f;
        }
        return super.mouseScrolled(mouseX, mouseY, mouseDeltaX, mouseDeltaY);
    }

    protected void containerTick() {
        super.containerTick();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
            this.initPanX = this.panX;
            this.initPanY = this.panY;
        }
    }

    private void onToggleViewport() {
        boolean bl = this.showMaterialList = !this.showMaterialList;
        if (this.showMaterialList) {
            this.buttonToggleViewport.setMessage((Component)Component.translatable((String)"buildinggadgets2.buttons.materials"));
        } else {
            this.buttonToggleViewport.setMessage((Component)Component.translatable((String)"buildinggadgets2.buttons.render"));
        }
    }

    private void onSave() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateTemplateManagerPayload(this.be.getBlockPos(), 0, this.nameField.getValue())});
    }

    private void onLoad() {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new UpdateTemplateManagerPayload(this.be.getBlockPos(), 1, this.nameField.getValue())});
    }

    private Template getTemplate() {
        ItemStack templateStack = this.container.getSlot(1).getItem();
        Template template = new Template("", new ArrayList<StatePos>());
        if (templateStack.isEmpty()) {
            return template;
        }
        UUID templateUUID = GadgetNBT.getUUID(templateStack);
        ArrayList<StatePos> statePosCache = BG2DataClient.getLookupFromUUID(templateUUID);
        if (statePosCache == null || statePosCache.isEmpty()) {
            return template;
        }
        template = new Template(this.nameField.getValue(), statePosCache);
        return template;
    }

    private void onCopy() {
        Template template = this.getTemplate();
        if (template.statePosArrayList.isEmpty()) {
            return;
        }
        try {
            String json = template.toJson();
            this.getMinecraft().keyboardHandler.setClipboard(json);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void onPaste() {
        assert (this.getMinecraft().player != null);
        String CBString = this.getMinecraft().keyboardHandler.getClipboard();
        ArrayList<Object> statePosArrayList = new ArrayList();
        try {
            Template template = new Template(CBString);
            if (template.statePosArrayList == null || template.statePosArrayList.equals("")) {
                return;
            }
            CompoundTag deserializedNBT = TagParser.parseTag((String)template.statePosArrayList);
            statePosArrayList = BG2Data.statePosListFromNBTMapArray(deserializedNBT);
        }
        catch (Exception e) {
            this.getMinecraft().player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.screen.invalidjson"), true);
            return;
        }
        if (statePosArrayList.isEmpty()) {
            return;
        }
        CompoundTag serverTag = BG2Data.statePosListToNBTMapArray(statePosArrayList);
        UUID copyUUID = UUID.randomUUID();
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SendPastePayload(copyUUID, serverTag)});
    }

    private void onReplace(BlockState targetState) {
        if (!this.showMaterialList || this.scrollingList.getSelected() == null) {
            return;
        }
    }

    private void doReplace(BlockState sourceState, BlockState targetState) {
        Template template = this.getTemplate();
        if (template.statePosArrayList.isEmpty()) {
            return;
        }
        template.replaceBlocks(sourceState, targetState);
    }

    static {
        vertexBuffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(renderType -> renderType, type -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
    }
}

