/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen.widgets;

import com.direwolf20.buildinggadgets2.setup.Registration;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class GuiIconActionable
extends Button {
    private Predicate<Boolean> action;
    private boolean selected;
    private boolean isSelectable;
    private final Color selectedColor = new Color(0, 255, 0, 50);
    private final Color deselectedColor;
    private Color activeColor = this.deselectedColor = new Color(255, 255, 255, 50);
    private final ResourceLocation selectedTexture;
    private final ResourceLocation deselectedTexture;

    public GuiIconActionable(int x, int y, String texture, Component message, boolean isSelectable, Predicate<Boolean> action) {
        super(x, y, 25, 25, message, button -> {}, Button.DEFAULT_NARRATION);
        this.isSelectable = isSelectable;
        this.action = action;
        this.setSelected(action.test(false));
        String assetLocation = "textures/gui/setting/%s.png";
        this.deselectedTexture = new ResourceLocation("buildinggadgets2", String.format(assetLocation, texture));
        this.selectedTexture = !isSelectable ? this.deselectedTexture : new ResourceLocation("buildinggadgets2", String.format(assetLocation, texture + "_selected"));
    }

    public GuiIconActionable(int x, int y, String texture, Component message, Predicate<Boolean> action) {
        this(x, y, texture, message, false, action);
    }

    public void setFaded(boolean faded) {
        this.alpha = faded ? 0.6f : 1.0f;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.activeColor = selected ? this.selectedColor : this.deselectedColor;
    }

    public void playDownSound(SoundManager soundHandler) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Registration.BEEP.get(), (float)(this.selected ? 0.6f : 1.0f)));
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        this.action.test(true);
        if (!this.isSelectable) {
            return;
        }
        this.setSelected(!this.selected);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.activeColor.getRGB());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(this.selected ? this.selectedTexture : this.deselectedTexture));
        RenderSystem.setShaderColor((float)((float)this.activeColor.getRed() / 255.0f), (float)((float)this.activeColor.getGreen() / 255.0f), (float)((float)this.activeColor.getBlue() / 255.0f), (float)this.alpha);
        ResourceLocation texture = this.selected ? this.selectedTexture : this.deselectedTexture;
        guiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        if (mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height) {
            guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage().getString(), mouseX > Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 ? mouseX + 2 : mouseX - Minecraft.getInstance().font.width(this.getMessage().getString()), mouseY - 10, this.activeColor.getRGB() | 0xFF000000);
        }
    }
}

