/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.blockentities;

import com.direwolf20.buildinggadgets2.client.particles.fluidparticle.FluidFlowParticleData;
import com.direwolf20.buildinggadgets2.client.particles.itemparticle.ItemFlowParticleData;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;

public class RenderBlockBE
extends BlockEntity {
    public byte drawSize;
    public BlockState renderBlock;
    public BlockState sourceBlock;
    public BlockState targetBlock;
    public CompoundTag blockEntityData;
    public boolean shrinking;
    public boolean exchanging;
    public byte renderType;

    public RenderBlockBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.RenderBlock_BE.get(), pos, state);
    }

    public void tickClient() {
        this.increaseDrawSize();
        if (this.renderType == 5) {
            this.drawParticles();
        }
    }

    public void drawParticles() {
        if (this.renderBlock == null) {
            return;
        }
        Random random = new Random();
        float nowScale = (float)this.drawSize / (float)this.getMaxSize();
        if (this.renderBlock.getFluidState().isEmpty()) {
            if (this.shrinking) {
                if (nowScale != 0.0f && nowScale < 0.5f) {
                    return;
                }
                ItemStack itemStack = GadgetUtils.getSimpleItemForBlock(this.renderBlock);
                BlockPos startPos = this.getBlockPos();
                if (nowScale != 0.0f) {
                    float yscale = Mth.lerp((float)nowScale, (float)0.75f, (float)1.0f);
                    ItemFlowParticleData data = new ItemFlowParticleData(itemStack, false, this.shrinking);
                    for (int i = 0; i < 2; ++i) {
                        double randomX = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)((float)startPos.getY() + yscale), (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                    }
                } else {
                    ItemFlowParticleData data = new ItemFlowParticleData(itemStack, true, this.shrinking);
                    for (int i = 0; i < 100; ++i) {
                        double randomX = random.nextFloat();
                        double randomY = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)startPos.getY() + randomY, (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                int i;
                ItemFlowParticleData data;
                ItemStack itemStack = GadgetUtils.getSimpleItemForBlock(this.renderBlock);
                BlockPos startPos = this.getBlockPos();
                if ((double)nowScale < 0.05) {
                    data = new ItemFlowParticleData(itemStack, true, !this.shrinking);
                    for (i = 0; i < 100; ++i) {
                        double randomX = random.nextFloat();
                        double randomY = random.nextFloat();
                        double randomZ = random.nextFloat();
                        this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)startPos.getY() + randomY, (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                    }
                }
                if (nowScale > 0.5f) {
                    return;
                }
                data = new ItemFlowParticleData(itemStack, false, this.shrinking);
                for (i = 0; i < 2; ++i) {
                    this.level.addParticle((ParticleOptions)data, (double)((float)startPos.getX() + 0.5f), (double)((float)startPos.getY() + 0.5f), (double)((float)startPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                }
            }
        } else if (this.shrinking) {
            if (nowScale != 0.0f && nowScale < 0.5f) {
                return;
            }
            BlockPos startPos = this.getBlockPos();
            if (nowScale != 0.0f) {
                float yscale = Mth.lerp((float)nowScale, (float)0.75f, (float)1.0f);
                FluidFlowParticleData data = new FluidFlowParticleData(new FluidStack(this.renderBlock.getFluidState().getType(), 1000), false, this.shrinking);
                for (int i = 0; i < 2; ++i) {
                    double randomX = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)((float)startPos.getY() + yscale), (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                }
            } else {
                FluidFlowParticleData data = new FluidFlowParticleData(new FluidStack(this.renderBlock.getFluidState().getType(), 1000), true, this.shrinking);
                for (int i = 0; i < 100; ++i) {
                    double randomX = random.nextFloat();
                    double randomY = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)startPos.getY() + randomY, (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                }
            }
        } else {
            int i;
            FluidFlowParticleData data;
            BlockPos startPos = this.getBlockPos();
            if ((double)nowScale < 0.05) {
                data = new FluidFlowParticleData(new FluidStack(this.renderBlock.getFluidState().getType(), 1000), true, !this.shrinking);
                for (i = 0; i < 100; ++i) {
                    double randomX = random.nextFloat();
                    double randomY = random.nextFloat();
                    double randomZ = random.nextFloat();
                    this.level.addParticle((ParticleOptions)data, (double)startPos.getX() + randomX, (double)startPos.getY() + randomY, (double)startPos.getZ() + randomZ, 0.0, 0.0, 0.0);
                }
            }
            if (nowScale > 0.5f) {
                return;
            }
            data = new FluidFlowParticleData(new FluidStack(this.renderBlock.getFluidState().getType(), 1000), false, this.shrinking);
            for (i = 0; i < 2; ++i) {
                this.level.addParticle((ParticleOptions)data, (double)((float)startPos.getX() + 0.5f), (double)((float)startPos.getY() + 0.5f), (double)((float)startPos.getZ() + 0.5f), 0.0, 0.0, 0.0);
            }
        }
    }

    public void tickServer() {
        this.increaseDrawSize();
        if (this.shrinking && this.drawSize <= 0) {
            if (this.exchanging) {
                this.shrinking = false;
                this.renderBlock = this.targetBlock;
                this.markDirtyClient();
            } else {
                this.setRealBlock(Blocks.AIR.defaultBlockState());
            }
        } else if (this.drawSize >= this.getMaxSize()) {
            this.setRealBlock(this.targetBlock);
        }
    }

    public byte getMaxSize() {
        if (this.renderType == 5) {
            return 40;
        }
        return 20;
    }

    public void setRealBlock(BlockState realBlock) {
        List<ItemStack> drops;
        Iterator<ItemStack> iterator;
        if (realBlock == null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        if (!realBlock.canSurvive((LevelReader)this.level, this.getBlockPos()) && (iterator = (drops = GadgetUtils.getDropsForBlockState((ServerLevel)this.level, this.getBlockPos(), realBlock, null)).iterator()).hasNext()) {
            ItemStack returnedItem = iterator.next();
            ItemEntity itementity = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), returnedItem);
            itementity.setPickUpDelay(40);
            this.level.addFreshEntity((Entity)itementity);
            this.level.setBlockAndUpdate(this.getBlockPos(), Blocks.AIR.defaultBlockState());
            return;
        }
        BlockState adjustedState = Block.updateFromNeighbourShapes((BlockState)realBlock, (LevelAccessor)this.level, (BlockPos)this.getBlockPos());
        this.level.setBlockAndUpdate(this.getBlockPos(), adjustedState);
        if (this.blockEntityData != null) {
            BlockEntity newBE = this.level.getBlockEntity(this.getBlockPos());
            try {
                newBE.load(this.blockEntityData);
            }
            catch (Exception e) {
                System.out.println("Failed to restore tile data for block at: " + this.getBlockPos() + " with NBT: " + this.blockEntityData + ". Consider adding it to the blacklist");
            }
        }
    }

    public void increaseDrawSize() {
        if (this.shrinking) {
            this.drawSize = (byte)(this.drawSize - 1);
            if (this.drawSize <= 0) {
                this.drawSize = 0;
            }
        } else {
            this.drawSize = (byte)(this.drawSize + 1);
            if (this.drawSize >= this.getMaxSize()) {
                this.drawSize = this.getMaxSize();
            }
        }
    }

    public byte nextDrawSize() {
        if (this.shrinking) {
            return (byte)(this.drawSize - 1);
        }
        return (byte)(this.drawSize + 1);
    }

    public void setRenderData(BlockState sourceBlock, BlockState targetBlock, byte renderType) {
        this.sourceBlock = sourceBlock;
        this.targetBlock = targetBlock;
        this.renderType = renderType;
        if (sourceBlock.equals(Blocks.AIR.defaultBlockState())) {
            this.exchanging = false;
            this.shrinking = false;
            this.renderBlock = targetBlock;
            this.drawSize = 0;
        } else if (targetBlock.equals(Blocks.AIR.defaultBlockState())) {
            this.exchanging = false;
            this.shrinking = true;
            this.renderBlock = sourceBlock;
            this.drawSize = this.getMaxSize();
        } else {
            this.exchanging = true;
            this.shrinking = true;
            this.renderBlock = sourceBlock;
            this.drawSize = this.getMaxSize();
        }
        this.markDirtyClient();
    }

    public void setBlockEntityData(CompoundTag tag) {
        this.blockEntityData = tag;
        this.markDirtyClient();
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.renderBlock = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("renderBlock"));
        this.sourceBlock = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("sourceBlock"));
        this.targetBlock = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("targetBlock"));
        this.shrinking = tag.getBoolean("shrinking");
        this.exchanging = tag.getBoolean("exchanging");
        this.drawSize = tag.getByte("drawSize");
        this.renderType = tag.getByte("renderType");
        if (tag.contains("blockEntityData")) {
            this.blockEntityData = tag.getCompound("blockEntityData");
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.renderBlock != null) {
            tag.put("renderBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.renderBlock));
        }
        if (this.sourceBlock != null) {
            tag.put("sourceBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.sourceBlock));
        }
        if (this.targetBlock != null) {
            tag.put("targetBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.targetBlock));
        }
        tag.putBoolean("shrinking", this.shrinking);
        tag.putBoolean("exchanging", this.exchanging);
        tag.putByte("drawSize", this.drawSize);
        tag.putByte("renderType", this.renderType);
        if (this.blockEntityData != null) {
            tag.put("blockEntityData", (Tag)this.blockEntityData);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.getTag() == null) {
            return;
        }
        this.load(pkt.getTag());
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }
}

