/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.blockentities;

import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.containers.customhandler.TemplateManagerHandler;
import com.direwolf20.buildinggadgets2.setup.Registration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TemplateManagerBE
extends BlockEntity
implements MenuProvider {
    public final TemplateManagerHandler itemHandler = new TemplateManagerHandler(2, this);

    public TemplateManagerBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.TemplateManager_BE.get(), pos, state);
    }

    public void load(CompoundTag tag) {
        if (tag.contains("Inventory")) {
            this.itemHandler.deserializeNBT(tag.getCompound("Inventory"));
        }
        super.load(tag);
    }

    @Nonnull
    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.load(pkt.getTag());
    }

    public void markDirtyClient() {
        this.setChanged();
        if (this.getLevel() != null) {
            BlockState state = this.getLevel().getBlockState(this.getBlockPos());
            this.getLevel().sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public void clearRemoved() {
        super.clearRemoved();
    }

    public Component getDisplayName() {
        return Component.translatable((String)"buildinggadgets2.screen.templatemanager");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new TemplateManagerContainer(i, playerInventory, this);
    }
}

