/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.commands;

import com.direwolf20.buildinggadgets2.common.network.data.SendCopyDataPayload;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MiscHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.google.common.collect.BiMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RedprintCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(p_214470_ -> p_214470_.hasPermission(0))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(p_214470_ -> p_214470_.hasPermission(0))).executes(p_258233_ -> RedprintCommand.listRedprints((CommandSourceStack)p_258233_.getSource())))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(p_214470_ -> p_214470_.hasPermission(3))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(p_258232_ -> RedprintCommand.removeRedprint((CommandSourceStack)p_258232_.getSource(), StringArgumentType.getString((CommandContext)p_258232_, (String)"name")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"give").requires(p_214470_ -> p_214470_.hasPermission(3))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.player()).executes(p_258232_ -> RedprintCommand.giveRedprint((CommandSourceStack)p_258232_.getSource(), StringArgumentType.getString((CommandContext)p_258232_, (String)"name"), EntityArgument.getPlayer((CommandContext)p_258232_, (String)"targets"))))));
    }

    private static int listRedprints(CommandSourceStack pSource) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.getPlayer().level().getServer()).overworld());
        BiMap<UUID, String> redmaps = bg2Data.getRedprintLookup();
        for (Map.Entry entry : redmaps.entrySet()) {
            pSource.sendSuccess(() -> Component.literal((String)((String)entry.getValue())), false);
        }
        return redmaps.size();
    }

    private static int removeRedprint(CommandSourceStack pSource, String name) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.getPlayer().level().getServer()).overworld());
        if (bg2Data.removeFromRedprints(name)) {
            pSource.sendSuccess(() -> Component.translatable((String)"buildinggadgets2.messages.redprintremovesuccess", (Object[])new Object[]{name}), false);
        } else {
            pSource.sendSuccess(() -> Component.translatable((String)"buildinggadgets2.messages.redprintremovefail", (Object[])new Object[]{name}), false);
        }
        return 1;
    }

    private static int giveRedprint(CommandSourceStack pSource, String name, ServerPlayer serverPlayer) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.getPlayer().level().getServer()).overworld());
        UUID sourceUUID = bg2Data.getRedprintUUIDfromName(name);
        if (sourceUUID == null) {
            pSource.sendSuccess(() -> Component.translatable((String)"buildinggadgets2.messages.redprintgivefail", (Object[])new Object[]{name, serverPlayer.getDisplayName()}), false);
            MiscHelpers.playSound(serverPlayer, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
            return 0;
        }
        ItemStack newRedprint = new ItemStack((ItemLike)Registration.Redprint.get());
        UUID targetUUID = GadgetNBT.getUUID(newRedprint);
        ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(sourceUUID, false);
        GadgetNBT.setCopyUUID(newRedprint);
        bg2Data.addToCopyPaste(targetUUID, buildList);
        ArrayList<TagPos> teMap = bg2Data.peekTEMap(sourceUUID);
        ArrayList<TagPos> copiedMap = new ArrayList<TagPos>(Objects.requireNonNullElseGet(teMap, ArrayList::new));
        bg2Data.addToTEMap(targetUUID, copiedMap);
        GadgetNBT.setTemplateName(newRedprint, name);
        CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(targetUUID, false);
        serverPlayer.connection.send((CustomPacketPayload)new SendCopyDataPayload(targetUUID, GadgetNBT.getCopyUUID(newRedprint), tag));
        serverPlayer.addItem(newRedprint);
        MiscHelpers.playSound(serverPlayer, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.ENCHANTMENT_TABLE_USE.getLocation().toString()))));
        return 1;
    }
}

