/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MagicHelpers;
import com.direwolf20.buildinggadgets2.util.Styles;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class BaseGadget
extends Item {
    public BaseGadget() {
        super(new Item.Properties().stacksTo(1));
    }

    public abstract int getEnergyMax();

    public abstract int getEnergyCost();

    public int getMaxDamage(ItemStack stack) {
        return this.getEnergyMax();
    }

    public boolean isBarVisible(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return false;
        }
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public int getBarWidth(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return 0;
        }
        return Math.min(13 * energy.getEnergyStored() / energy.getMaxEnergyStored(), 13);
    }

    public int getBarColor(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy == null) {
            return super.getBarColor(stack);
        }
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        boolean sneakPressed = Screen.hasShiftDown();
        if (!sneakPressed) {
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.holdshift", (Object[])new Object[]{"shift"}).withStyle(ChatFormatting.GRAY));
        } else {
            DimBlockPos boundTo = GadgetNBT.getBoundPos(stack);
            if (boundTo != null) {
                tooltip.add((Component)Component.translatable((String)"buildinggadgets2.tooltips.boundto", (Object[])new Object[]{boundTo.levelKey.location().getPath(), "[" + boundTo.blockPos.toShortString() + "]"}).setStyle(Styles.GOLD));
            }
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energy != null) {
            MutableComponent energyText = !sneakPressed ? Component.translatable((String)"buildinggadgets2.tooltips.energy", (Object[])new Object[]{MagicHelpers.tidyValue(energy.getEnergyStored()), MagicHelpers.tidyValue(energy.getMaxEnergyStored())}) : Component.translatable((String)"buildinggadgets2.tooltips.energy", (Object[])new Object[]{String.format("%,d", energy.getEnergyStored()), String.format("%,d", energy.getMaxEnergyStored())});
            tooltip.add((Component)energyText.withStyle(ChatFormatting.GREEN));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack gadget = player.getItemInHand(hand);
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)gadget);
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
        if (level.getBlockState(lookingAt.getBlockPos()).isAir() && GadgetNBT.getAnchorPos(gadget).equals((Object)GadgetNBT.nullPos)) {
            return InteractionResultHolder.success((Object)gadget);
        }
        ItemActionContext context = new ItemActionContext(lookingAt.getBlockPos(), lookingAt, player, level, hand, gadget);
        if (player.isShiftKeyDown()) {
            if (GadgetNBT.getSetting(gadget, "bind")) {
                if (this.bindToInventory(level, player, gadget, lookingAt)) {
                    GadgetNBT.toggleSetting(gadget, "bind");
                    return InteractionResultHolder.success((Object)gadget);
                }
                return InteractionResultHolder.fail((Object)gadget);
            }
            return this.onShiftAction(context);
        }
        return this.onAction(context);
    }

    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        return InteractionResultHolder.pass((Object)context.stack());
    }

    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        return InteractionResultHolder.pass((Object)context.stack());
    }

    public boolean bindToInventory(Level level, Player player, ItemStack gadget, BlockHitResult lookingAt) {
        IItemHandler itemHandler;
        BlockEntity blockEntity = level.getBlockEntity(lookingAt.getBlockPos());
        if (blockEntity != null && (itemHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, lookingAt.getBlockPos(), (Object)lookingAt.getDirection())) != null) {
            GadgetNBT.setBoundPos(gadget, new DimBlockPos(level, lookingAt.getBlockPos()));
            GadgetNBT.setToolValue(gadget, lookingAt.getDirection().ordinal(), "binddirection");
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.bindsuccess", (Object[])new Object[]{lookingAt.getBlockPos().toShortString()}), true);
            return true;
        }
        DimBlockPos existingBind = GadgetNBT.getBoundPos(gadget);
        if (existingBind != null) {
            GadgetNBT.clearBoundPos(gadget);
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.bindremoved"), true);
            return true;
        }
        player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.bindfailed"), true);
        return false;
    }

    public ResourceLocation rotateModes(ItemStack stack) {
        BaseMode currentMode;
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(this.gadgetTarget());
        ArrayList<BaseMode> arrayOfModes = new ArrayList<BaseMode>((Collection<BaseMode>)modesForGadget);
        int modeIndex = arrayOfModes.indexOf(currentMode = GadgetNBT.getMode(stack));
        if (modeIndex == -1 || ++modeIndex > arrayOfModes.size()) {
            modeIndex = 0;
        }
        BaseMode mode = arrayOfModes.get(modeIndex);
        GadgetNBT.setMode(stack, mode);
        return mode.getId();
    }

    public abstract GadgetTarget gadgetTarget();

    public static ItemStack getGadget(Player player) {
        ItemStack heldItem = player.getMainHandItem();
        if (!(heldItem.getItem() instanceof BaseGadget) && !((heldItem = player.getOffhandItem()).getItem() instanceof BaseGadget)) {
            return ItemStack.EMPTY;
        }
        return heldItem;
    }

    public static BlockPos getHitPos(ItemActionContext context) {
        BlockPos anchorPos = GadgetNBT.getAnchorPos(context.stack());
        return anchorPos.equals((Object)GadgetNBT.nullPos) ? context.pos() : anchorPos;
    }

    public boolean canUndo(Level level, Player player, ItemStack gadget) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        ArrayList<StatePos> undoList = bg2Data.peekUndoList(GadgetNBT.peekUndoList(gadget));
        for (StatePos statePos : undoList) {
            if (level.isLoaded(statePos.pos)) continue;
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.undofailedunloaded", (Object[])new Object[]{statePos.pos.toShortString()}), true);
            return false;
        }
        return true;
    }

    public void undo(Level level, Player player, ItemStack gadget) {
        if (!this.canUndo(level, player, gadget)) {
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.getServer()).overworld());
        UUID buildUUID = GadgetNBT.popUndoList(gadget);
        ServerTickHandler.stopBuilding(buildUUID);
        ArrayList<StatePos> undoList = bg2Data.popUndoList(buildUUID);
        if (undoList.isEmpty()) {
            return;
        }
        Collections.reverse(undoList);
        ArrayList<BlockPos> todoList = new ArrayList<BlockPos>();
        for (StatePos statePos : undoList) {
            todoList.add(statePos.pos);
        }
        boolean giveItemsBack = !player.isCreative();
        BuildingUtils.removeTickHandler(level, player, todoList, giveItemsBack, giveItemsBack, gadget);
    }
}

