/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.datagen.BG2BlockTags;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.VecHelpers;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.direwolf20.buildinggadgets2.util.modes.Cut;
import com.direwolf20.buildinggadgets2.util.modes.Paste;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GadgetCutPaste
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.CUTPASTEGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.CUTPASTEGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean sneakPressed;
        super.appendHoverText(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.getInstance();
        if (level == null || mc.player == null) {
            return;
        }
        if (GadgetNBT.getPasteReplace(stack)) {
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.voidwarning").withStyle(ChatFormatting.RED));
        }
        if (sneakPressed = Screen.hasShiftDown()) {
            // empty if block
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (!mode.getId().getPath().equals("cut")) {
            if (mode.getId().getPath().equals("paste")) {
                UUID uuid = GadgetNBT.getUUID(gadget);
                if (ServerTickHandler.gadgetWorking(GadgetNBT.getUUID(gadget))) {
                    context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.cutinprogress"), true);
                    return InteractionResultHolder.pass((Object)gadget);
                }
                BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().level().getServer()).overworld());
                ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(uuid, false);
                Collections.reverse(buildList);
                ArrayList<TagPos> tagList = bg2Data.peekTEMap(uuid);
                ArrayList<StatePos> actuallyBuiltList = BuildingUtils.buildWithTileData(context.level(), context.player(), buildList, GadgetCutPaste.getHitPos(context).above().offset((Vec3i)GadgetNBT.getRelativePaste(gadget)), tagList, gadget);
                if (!actuallyBuiltList.isEmpty()) {
                    GadgetNBT.clearAnchorPos(gadget);
                }
                GadgetNBT.clearCopyUUID(gadget);
                GadgetNBT.setMode(gadget, new Cut());
                return InteractionResultHolder.success((Object)gadget);
            }
            return InteractionResultHolder.pass((Object)gadget);
        }
        GadgetNBT.setCopyStartPos(gadget, context.pos());
        return InteractionResultHolder.success((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (mode.getId().getPath().equals("cut")) {
            GadgetNBT.setCopyEndPos(gadget, context.pos());
        } else if (!mode.equals(new Paste())) {
            return InteractionResultHolder.pass((Object)gadget);
        }
        return InteractionResultHolder.success((Object)gadget);
    }

    public void cutAndStore(Player player, ItemStack gadget) {
        int maxSize;
        if (ServerTickHandler.gadgetWorking(GadgetNBT.getUUID(gadget))) {
            return;
        }
        ArrayList<StatePos> buildList = new ArrayList<StatePos>();
        ArrayList<TagPos> teData = new ArrayList<TagPos>();
        UUID buildUUID = UUID.randomUUID();
        ItemStack heldItem = BaseGadget.getGadget(player);
        Item item = heldItem.getItem();
        if (!(item instanceof GadgetCutPaste)) {
            return;
        }
        GadgetCutPaste gadgetCutPaste = (GadgetCutPaste)item;
        Level level = player.level();
        BlockPos cutStart = GadgetNBT.getCopyStartPos(heldItem);
        BlockPos cutEnd = GadgetNBT.getCopyEndPos(heldItem);
        if (cutStart.equals((Object)GadgetNBT.nullPos) || cutEnd.equals((Object)GadgetNBT.nullPos)) {
            return;
        }
        AABB area = VecHelpers.aabbFromBlockPos(cutStart, cutEnd);
        int maxAxis = 500;
        if (area.getXsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"x", maxAxis, area.getXsize()}), false);
            return;
        }
        if (area.getYsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"y", maxAxis, area.getYsize()}), false);
            return;
        }
        if (area.getZsize() > (double)maxAxis) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.axistoolarge", (Object[])new Object[]{"z", maxAxis, area.getZsize()}), false);
            return;
        }
        Stream areaStream = BlockPos.betweenClosedStream((AABB)area);
        long size = areaStream.count();
        if (size > (long)(maxSize = 100000)) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.areatoolarge", (Object[])new Object[]{maxSize, size}), false);
            return;
        }
        int totalCost = gadgetCutPaste.getEnergyCost() * (int)size;
        if (!player.isCreative() && !BuildingUtils.hasEnoughEnergy(heldItem, totalCost)) {
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.notenoughenergy", (Object[])new Object[]{totalCost, BuildingUtils.getEnergyStored(heldItem)}), false);
            return;
        }
        BlockPos.betweenClosedStream((AABB)area).map(BlockPos::immutable).sorted(Comparator.comparingInt(Vec3i::getY).reversed()).forEach(pos -> ServerTickHandler.addToMap(buildUUID, new StatePos(Blocks.AIR.defaultBlockState(), (BlockPos)pos), level, GadgetNBT.getRenderTypeByte(gadget), player, false, false, gadget, ServerBuildList.BuildType.CUT, false, BlockPos.ZERO));
        ServerTickHandler.setCutStart(buildUUID, cutStart);
        GadgetNBT.setCopyStartPos(gadget, GadgetNBT.nullPos);
        GadgetNBT.setCopyEndPos(gadget, GadgetNBT.nullPos);
        player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.cutblocks", (Object[])new Object[]{size}), true);
        UUID uuid = GadgetNBT.getUUID(gadget);
        GadgetNBT.setCopyUUID(gadget, buildUUID);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(player.level().getServer()).overworld());
        bg2Data.addToCopyPaste(uuid, buildList);
        bg2Data.addToTEMap(uuid, teData);
    }

    public static boolean customCutValidation(BlockState blockState, Level level, Player player, BlockPos blockPos) {
        if (blockState.is(BG2BlockTags.NO_MOVE)) {
            return false;
        }
        return level.mayInteract(player, blockPos);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.CUTPASTE;
    }
}

