/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.handler;

import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.network.data.SendCopyDataPayload;
import com.direwolf20.buildinggadgets2.common.network.data.UpdateTemplateManagerPayload;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MiscHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketUpdateTemplateManager {
    public static final PacketUpdateTemplateManager INSTANCE = new PacketUpdateTemplateManager();

    public static PacketUpdateTemplateManager get() {
        return INSTANCE;
    }

    public void handle(UpdateTemplateManagerPayload payload, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            Optional sender = context.player();
            if (sender.isEmpty()) {
                return;
            }
            Player player = (Player)sender.get();
            AbstractContainerMenu container = player.containerMenu;
            if (container == null || !(container instanceof TemplateManagerContainer)) {
                return;
            }
            ItemStack gadgetStack = container.getSlot(0).getItem();
            ItemStack templateStack = container.getSlot(1).getItem();
            if (payload.mode() == 0) {
                if (templateStack.isEmpty()) {
                    GadgetNBT.setTemplateName(gadgetStack, payload.templateName());
                    return;
                }
                if (templateStack.is(Items.PAPER)) {
                    UUID sourceUUID = GadgetNBT.getUUID(gadgetStack);
                    BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(player.level().getServer()).overworld());
                    ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(sourceUUID, false);
                    if (buildList == null || buildList.isEmpty()) {
                        MiscHelpers.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                        return;
                    }
                    container.setItem(1, container.getStateId(), new ItemStack((ItemLike)Registration.Template.get()));
                    templateStack = container.getSlot(1).getItem();
                }
                if (templateStack.is((Item)Registration.Redprint.get()) && payload.templateName().isEmpty()) {
                    player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.namerequired"), true);
                    MiscHelpers.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                    return;
                }
                GadgetNBT.setTemplateName(templateStack, payload.templateName());
                if (gadgetStack.isEmpty()) {
                    return;
                }
                PacketUpdateTemplateManager.copyData((ServerPlayer)player, gadgetStack, templateStack, payload.templateName());
            } else if (payload.mode() == 1) {
                if (templateStack.isEmpty() || gadgetStack.isEmpty()) {
                    MiscHelpers.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                    return;
                }
                if (templateStack.is((Item)Registration.Redprint.get()) && !gadgetStack.is((Item)Registration.CutPaste_Gadget.get())) {
                    MiscHelpers.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                    return;
                }
                if (gadgetStack.is((Item)Registration.CutPaste_Gadget.get()) && !templateStack.is((Item)Registration.Redprint.get())) {
                    MiscHelpers.playSound((ServerPlayer)player, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
                    return;
                }
                PacketUpdateTemplateManager.copyData((ServerPlayer)player, templateStack, gadgetStack, payload.templateName());
                GadgetNBT.setTemplateName(gadgetStack, GadgetNBT.getTemplateName(templateStack));
            }
        });
    }

    public static void copyData(ServerPlayer sender, ItemStack sourceStack, ItemStack targetStack, String templateName) {
        UUID targetUUID = GadgetNBT.getUUID(targetStack);
        UUID sourceUUID = GadgetNBT.getUUID(sourceStack);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(sender.level().getServer()).overworld());
        if (targetStack.is((Item)Registration.Redprint.get()) && !bg2Data.addToRedprints(targetUUID, templateName)) {
            sender.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.namealreadyexists"), true);
            MiscHelpers.playSound(sender, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
            return;
        }
        ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(sourceUUID, false);
        if (buildList == null || buildList.isEmpty()) {
            MiscHelpers.playSound(sender, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.WAXED_SIGN_INTERACT_FAIL.getLocation().toString()))));
            return;
        }
        GadgetNBT.setCopyUUID(targetStack);
        bg2Data.addToCopyPaste(targetUUID, buildList);
        if (sourceStack.is((Item)Registration.Redprint.get()) || targetStack.is((Item)Registration.Redprint.get())) {
            ArrayList<TagPos> teMap = bg2Data.peekTEMap(sourceUUID);
            ArrayList<TagPos> copiedMap = new ArrayList<TagPos>(Objects.requireNonNullElseGet(teMap, ArrayList::new));
            bg2Data.addToTEMap(targetUUID, copiedMap);
        }
        if (sourceStack.is((Item)Registration.Redprint.get())) {
            sourceStack.shrink(1);
        }
        CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(sourceUUID, false);
        sender.connection.send((CustomPacketPayload)new SendCopyDataPayload(sourceUUID, GadgetNBT.getCopyUUID(sourceStack), tag));
        tag = bg2Data.getCopyPasteListAsNBTMap(targetUUID, false);
        sender.connection.send((CustomPacketPayload)new SendCopyDataPayload(targetUUID, GadgetNBT.getCopyUUID(targetStack), tag));
        MiscHelpers.playSound(sender, (Holder<SoundEvent>)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)new ResourceLocation(SoundEvents.ENCHANTMENT_TABLE_USE.getLocation().toString()))));
    }
}

