/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.handler.gadgetaction;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.common.containers.TemplateManagerContainer;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.network.data.SendCopyDataPayload;
import com.direwolf20.buildinggadgets2.common.network.handler.gadgetaction.GadgetActionCodecs;
import com.direwolf20.buildinggadgets2.common.network.handler.gadgetaction.GadgetActionContext;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.collect.ImmutableSortedSet;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public enum ActionGadget {
    ANCHOR(context -> {
        Player player = context.player();
        ItemStack gadgetStack = context.gadget();
        if (!GadgetNBT.getAnchorPos(gadgetStack).equals((Object)GadgetNBT.nullPos)) {
            GadgetNBT.clearAnchorPos(gadgetStack);
            player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.anchorcleared"), true);
            return;
        }
        BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadgetStack);
        BlockPos lookingAtPos = lookingAt.getBlockPos();
        BlockState lookingAtState = player.level().getBlockState(lookingAtPos);
        if (lookingAtState.isAir()) {
            return;
        }
        GadgetNBT.setAnchorPos(gadgetStack, lookingAtPos);
        GadgetNBT.setAnchorSide(gadgetStack, lookingAt.getDirection());
        if (gadgetStack.getItem() instanceof GadgetBuilding || gadgetStack.getItem() instanceof GadgetExchanger) {
            BlockState renderBlockState = GadgetNBT.getGadgetBlockState(gadgetStack);
            if (renderBlockState.isAir()) {
                return;
            }
            BaseMode mode = GadgetNBT.getMode(gadgetStack);
            ArrayList<StatePos> buildList = mode.collect(lookingAt.getDirection(), player, lookingAtPos, renderBlockState);
            ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
            buildList.forEach(e -> blockPosList.add(e.pos));
            GadgetNBT.setAnchorList(gadgetStack, blockPosList);
        }
        player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.anchorset").append(lookingAtPos.toShortString()), true);
    }),
    COPY_COORDS(context -> {
        Player player = context.player();
        ItemStack gadgetStack = context.gadget();
        ActionGadget.lazyCodecRead(GadgetActionCodecs.BiPos.CODEC, context.payload().metaData(), biPos -> {
            GadgetNBT.setCopyStartPos(gadgetStack, biPos.startPos());
            GadgetNBT.setCopyEndPos(gadgetStack, biPos.endPos());
            Item patt3920$temp = gadgetStack.getItem();
            if (patt3920$temp instanceof GadgetCopyPaste) {
                GadgetCopyPaste gadgetCopyPaste = (GadgetCopyPaste)patt3920$temp;
                BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadgetStack);
                ItemActionContext itemContext = new ItemActionContext(lookingAt.getBlockPos(), lookingAt, player, player.level(), InteractionHand.MAIN_HAND, gadgetStack);
                gadgetCopyPaste.buildAndStore(itemContext, gadgetStack);
            }
        }, error -> player.displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true));
    }),
    CUT(context -> {
        ItemStack gadget = context.gadget();
        Item patt4606$temp = gadget.getItem();
        if (patt4606$temp instanceof GadgetCutPaste) {
            GadgetCutPaste gadgetCopyPaste = (GadgetCutPaste)patt4606$temp;
            gadgetCopyPaste.cutAndStore(context.player(), gadget);
        }
    }),
    DESTRUCTION_RANGES(context -> ActionGadget.lazyCodecRead(GadgetActionCodecs.DestructionRanges.CODEC, context.payload().metaData(), destructionRanges -> {
        GadgetNBT.setToolValue(context.gadget(), destructionRanges.left(), "left");
        GadgetNBT.setToolValue(context.gadget(), destructionRanges.right(), "right");
        GadgetNBT.setToolValue(context.gadget(), destructionRanges.up(), "up");
        GadgetNBT.setToolValue(context.gadget(), destructionRanges.down(), "down");
        GadgetNBT.setToolValue(context.gadget(), destructionRanges.depth(), "depth");
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    MODE_SWITCH(context -> ActionGadget.lazyCodecRead(GadgetActionCodecs.ModeSwitch.CODEC, context.payload().metaData(), modeSwitch -> {
        ItemStack gadget = context.gadget();
        BaseGadget actualGadget = (BaseGadget)context.gadget().getItem();
        if (modeSwitch.rotate()) {
            actualGadget.rotateModes(gadget);
        }
        ResourceLocation modeId = modeSwitch.modeId();
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(actualGadget.gadgetTarget());
        BaseMode modeToUse = modesForGadget.stream().filter(e -> e.getId().equals((Object)modeId)).findFirst().orElse((BaseMode)modesForGadget.first());
        GadgetNBT.setMode(gadget, modeToUse);
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    RANGE_CHANGE(context -> ActionGadget.lazyCodecRead(Codec.INT, context.payload().metaData(), range -> {
        GadgetNBT.setToolRange(context.gadget(), range);
        context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.range_set", (Object[])new Object[]{range}), true);
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    RELATIVE_PASTE(context -> ActionGadget.lazyCodecRead(BlockPos.CODEC, context.payload().metaData(), relativePos -> {
        GadgetNBT.setRelativePaste(context.gadget(), relativePos);
        context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.relativepaste", (Object[])new Object[]{relativePos.toShortString()}), true);
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    RENDER_CHANGE(context -> ActionGadget.lazyCodecRead(Codec.BYTE, context.payload().metaData(), renderType -> {
        GadgetNBT.setRenderType(context.gadget(), renderType);
        context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.render_set", (Object[])new Object[]{Component.translatable((String)GadgetNBT.getRenderType(context.gadget()).getLang())}), true);
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    ROTATE(context -> {
        ItemStack gadget = context.gadget();
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (gadget.getItem() instanceof GadgetCutPaste && ServerTickHandler.gadgetWorking(gadgetUUID)) {
            context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.cutinprogress"), true);
            return;
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().level().getServer()).overworld());
        ArrayList<StatePos> currentPosList = bg2Data.getCopyPasteList(gadgetUUID, false);
        ArrayList<TagPos> tagListMutable = bg2Data.peekTEMap(gadgetUUID);
        ArrayList<StatePos> newPosList = StatePos.rotate90Degrees(currentPosList, tagListMutable);
        bg2Data.addToCopyPaste(gadgetUUID, newPosList);
        GadgetNBT.setCopyUUID(gadget);
        if (tagListMutable == null || tagListMutable.isEmpty()) {
            return;
        }
        bg2Data.addToTEMap(gadgetUUID, tagListMutable);
    }),
    SEND_COPY_DATA_TO_SERVER(context -> ActionGadget.lazyCodecRead(CompoundTag.CODEC, context.payload().metaData(), compoundTag -> {
        AbstractContainerMenu container = context.player().containerMenu;
        if (container == null || !(container instanceof TemplateManagerContainer)) {
            return;
        }
        ItemStack templateStack = container.getSlot(1).getItem();
        if (templateStack.isEmpty()) {
            return;
        }
        if (templateStack.is(Items.PAPER)) {
            container.setItem(1, container.getStateId(), new ItemStack((ItemLike)Registration.Template.get()));
            templateStack = container.getSlot(1).getItem();
        }
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().level().getServer()).overworld());
        ArrayList<StatePos> buildList = BG2Data.statePosListFromNBTMapArray(compoundTag);
        bg2Data.addToCopyPaste(GadgetNBT.getUUID(templateStack), buildList);
        GadgetNBT.setCopyUUID(templateStack);
        CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(GadgetNBT.getUUID(templateStack), false);
        ((ServerPlayer)context.player()).connection.send((CustomPacketPayload)new SendCopyDataPayload(GadgetNBT.getUUID(templateStack), GadgetNBT.getCopyUUID(templateStack), tag));
    }, error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    TOGGLE_SETTING(context -> ActionGadget.lazyCodecRead(Codec.STRING, context.payload().metaData(), setting -> GadgetNBT.toggleSetting(context.gadget(), setting), error -> context.player().displayClientMessage((Component)Component.translatable((String)"buildinggadgets2.messages.copycoordsfailed"), true))),
    UNDO(context -> {
        Item patt11947$temp = context.gadget().getItem();
        if (patt11947$temp instanceof BaseGadget) {
            BaseGadget actualGadget = (BaseGadget)patt11947$temp;
            actualGadget.undo(context.player().level(), context.player(), context.gadget());
        }
    });

    private final Consumer<GadgetActionContext> handler;

    private ActionGadget(Consumer<GadgetActionContext> handler) {
        this.handler = handler;
    }

    public Consumer<GadgetActionContext> getHandler() {
        return this.handler;
    }

    private static <T> void lazyCodecRead(Codec<T> codec, Tag compound, Consumer<T> onSuccess, Consumer<String> onFailure) {
        DataResult parseResult = codec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound);
        Either result = parseResult.get();
        result.ifLeft(onSuccess);
        result.ifRight(partialResult -> onFailure.accept(partialResult.message()));
    }
}

