/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.worlddata;

import com.direwolf20.buildinggadgets2.common.network.data.RequestCopyDataPayload;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class BG2DataClient {
    private static final HashMap<UUID, ArrayList<StatePos>> copyPasteLookup = new HashMap();
    private static final HashMap<UUID, UUID> copyPasteCache = new HashMap();
    public static boolean awaitingUpdate = false;
    public static int updateTimer = 0;

    public static void updateLookupFromNBT(UUID gadgetUUID, UUID copyUUID, ArrayList<StatePos> list) {
        if (copyPasteLookup.containsKey(gadgetUUID)) {
            copyPasteLookup.remove(gadgetUUID);
        }
        copyPasteLookup.put(gadgetUUID, list);
        if (copyPasteCache.containsKey(gadgetUUID)) {
            copyPasteCache.remove(gadgetUUID);
        }
        copyPasteCache.put(gadgetUUID, copyUUID);
        updateTimer = 0;
        awaitingUpdate = false;
    }

    public static boolean isClientUpToDate(ItemStack gadget) {
        UUID gadgetUUID = GadgetNBT.getUUID(gadget);
        if (!GadgetNBT.hasCopyUUID(gadget)) {
            return false;
        }
        UUID copyUUID = GadgetNBT.getCopyUUID(gadget);
        UUID copyPasteUUIDCache = copyPasteCache.get(gadgetUUID);
        if (copyPasteUUIDCache != null && copyPasteUUIDCache.equals(copyUUID)) {
            return true;
        }
        if (awaitingUpdate && updateTimer < 100) {
            ++updateTimer;
            return false;
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new RequestCopyDataPayload(gadgetUUID, copyUUID)});
        awaitingUpdate = true;
        updateTimer = 0;
        return false;
    }

    public static ArrayList<StatePos> getLookupFromUUID(UUID gadgetUUID) {
        return copyPasteLookup.get(gadgetUUID);
    }

    public static UUID getCopyUUID(UUID gadgetUUID) {
        return copyPasteCache.get(gadgetUUID);
    }
}

