/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class DimBlockPos {
    public BlockPos blockPos;
    public ResourceKey<Level> levelKey;

    public DimBlockPos(Level level, BlockPos blockPos) {
        this.blockPos = blockPos;
        this.levelKey = level.dimension();
    }

    public DimBlockPos(ResourceKey<Level> levelKey, BlockPos blockPos) {
        this.blockPos = blockPos;
        this.levelKey = levelKey;
    }

    public DimBlockPos(CompoundTag tag) {
        this.levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(tag.getString("level")));
        this.blockPos = NbtUtils.readBlockPos((CompoundTag)tag.getCompound("blockpos"));
    }

    public Level getLevel(MinecraftServer server) {
        if (server == null) {
            return null;
        }
        return server.getLevel(this.levelKey);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putString("level", this.levelKey.location().toString());
        tag.put("blockpos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.blockPos));
        return tag;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimBlockPos) {
            return ((DimBlockPos)obj).levelKey == this.levelKey && Objects.equals(((DimBlockPos)obj).blockPos, this.blockPos);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.blockPos);
        result = 31 * result + Objects.hashCode(this.levelKey);
        return result;
    }
}

