/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GadgetNBT {
    public static final BlockPos nullPos = new BlockPos(-999, -999, -999);
    static final int undoListSize = 10;

    public static DimBlockPos setBoundPos(ItemStack gadget, DimBlockPos dimBlockPos) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("bound", (Tag)dimBlockPos.toNBT());
        return dimBlockPos;
    }

    public static DimBlockPos getBoundPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("bound")) {
            return null;
        }
        return new DimBlockPos(tag.getCompound("bound"));
    }

    public static void clearBoundPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("bound")) {
            return;
        }
        tag.remove("bound");
    }

    public static BlockPos setAnchorPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("anchor", (Tag)NbtUtils.writeBlockPos((BlockPos)blockPos));
        return blockPos;
    }

    public static byte setRenderType(ItemStack gadget, byte renderType) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.putByte("rendertype", renderType);
        return renderType;
    }

    public static byte getRenderTypeByte(ItemStack stack) {
        CompoundTag tagCompound = stack.getTag();
        if (tagCompound == null || !tagCompound.contains("rendertype")) {
            return 0;
        }
        return tagCompound.getByte("rendertype");
    }

    public static RenderTypes getRenderType(ItemStack stack) {
        return RenderTypes.getByOrdinal(GadgetNBT.getRenderTypeByte(stack));
    }

    public static BlockPos getAnchorPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("anchor")) {
            return nullPos;
        }
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound("anchor"));
    }

    public static void clearAnchorPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("anchor")) {
            return;
        }
        tag.remove("anchor");
        tag.remove("anchorList");
        tag.remove("anchorside");
    }

    public static ArrayList<BlockPos> getAnchorList(ItemStack gadget) {
        ArrayList<BlockPos> anchorList = new ArrayList<BlockPos>();
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("anchorList")) {
            return anchorList;
        }
        ListTag coordList = tag.getList("anchorList", 10);
        if (coordList.size() == 0) {
            return anchorList;
        }
        for (int i = 0; i < coordList.size(); ++i) {
            anchorList.add(NbtUtils.readBlockPos((CompoundTag)coordList.getCompound(i)));
        }
        return anchorList;
    }

    public static void setAnchorList(ItemStack gadget, ArrayList<BlockPos> anchorList) {
        CompoundTag tagCompound = gadget.getOrCreateTag();
        tagCompound.put("anchorList", (Tag)anchorList.stream().map(NbtUtils::writeBlockPos).collect(Collectors.toCollection(ListTag::new)));
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        CompoundTag tag = stack.getOrCreateTag();
        if (side == null) {
            tag.remove("anchorside");
        } else {
            tag.putInt("anchorside", side.ordinal());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag == null || !tag.contains("anchorside")) {
            return null;
        }
        int side = tag.getInt("anchorside");
        return Direction.values()[side];
    }

    public static BlockPos setCopyStartPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("copystart", (Tag)NbtUtils.writeBlockPos((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getCopyStartPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("copystart")) {
            return nullPos;
        }
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound("copystart"));
    }

    public static BlockPos setRelativePaste(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("relativepaste", (Tag)NbtUtils.writeBlockPos((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getRelativePaste(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("relativepaste")) {
            return BlockPos.ZERO;
        }
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound("relativepaste"));
    }

    public static BlockPos setCopyEndPos(ItemStack gadget, BlockPos blockPos) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("copyend", (Tag)NbtUtils.writeBlockPos((BlockPos)blockPos));
        return blockPos;
    }

    public static BlockPos getCopyEndPos(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("copyend")) {
            return nullPos;
        }
        return NbtUtils.readBlockPos((CompoundTag)tag.getCompound("copyend"));
    }

    public static UUID setUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getOrCreateTag();
        UUID uuid = UUID.randomUUID();
        tag.putUUID("uuid", uuid);
        return uuid;
    }

    public static UUID getUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("uuid")) {
            return GadgetNBT.setUUID(gadget);
        }
        return tag.getUUID("uuid");
    }

    public static UUID setCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getOrCreateTag();
        UUID uuid = UUID.randomUUID();
        tag.putUUID("copyuuid", uuid);
        return uuid;
    }

    public static UUID setCopyUUID(ItemStack gadget, UUID uuid) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.putUUID("copyuuid", uuid);
        return uuid;
    }

    public static UUID getCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("copyuuid")) {
            return GadgetNBT.setCopyUUID(gadget);
        }
        return tag.getUUID("copyuuid");
    }

    public static boolean hasCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        return tag != null && tag.contains("copyuuid");
    }

    public static void clearCopyUUID(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("copyuuid")) {
            return;
        }
        tag.remove("copyuuid");
    }

    public static BlockState setGadgetBlockState(ItemStack gadget, BlockState blockState) {
        CompoundTag tag = gadget.getOrCreateTag();
        tag.put("blockstate", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
        return blockState;
    }

    public static BlockState getGadgetBlockState(ItemStack gadget) {
        CompoundTag tag = gadget.getTag();
        if (tag == null || !tag.contains("blockstate")) {
            return Blocks.AIR.defaultBlockState();
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("blockstate"));
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return GadgetNBT.getSetting(stack, "raytracefluid");
    }

    public static LinkedList<UUID> getUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = new LinkedList<UUID>();
        CompoundTag tag = gadget.getOrCreateTag();
        if (!tag.contains("undolist")) {
            return undoList;
        }
        ListTag undoListTag = tag.getList("undolist", 10);
        for (int i = 0; i < undoListTag.size(); ++i) {
            UUID uuid = undoListTag.getCompound(i).getUUID("uuid");
            undoList.offer(uuid);
        }
        return undoList;
    }

    public static void setUndoList(ItemStack gadget, LinkedList<UUID> undoList) {
        CompoundTag tag = gadget.getOrCreateTag();
        ListTag undoListTag = new ListTag();
        for (UUID id : undoList) {
            CompoundTag temptag = new CompoundTag();
            temptag.putUUID("uuid", id);
            undoListTag.add((Object)temptag);
        }
        tag.put("undolist", (Tag)undoListTag);
    }

    public static void addToUndoList(ItemStack gadget, UUID uuid, BG2Data bg2Data) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.size() >= 10) {
            UUID removal = undoList.removeFirst();
            bg2Data.removeFromUndoList(removal);
        }
        undoList.add(uuid);
        GadgetNBT.setUndoList(gadget, undoList);
    }

    public static UUID peekUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        return undoList.getLast();
    }

    public static UUID popUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        UUID uuid = undoList.removeLast();
        GadgetNBT.setUndoList(gadget, undoList);
        return uuid;
    }

    public static boolean toggleSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound;
        tagCompound.putBoolean(setting, !(tagCompound = stack.getOrCreateTag()).getBoolean(setting));
        return tagCompound.getBoolean(setting);
    }

    public static boolean getSetting(ItemStack stack, String setting) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        return tagCompound.getBoolean(setting);
    }

    public static boolean getPasteReplace(ItemStack stack) {
        CompoundTag tag = stack.getTag();
        if (tag == null || !tag.contains("pastereplace")) {
            if (stack.getItem() instanceof GadgetCutPaste) {
                return GadgetNBT.toggleSetting(stack, "pastereplace");
            }
            return false;
        }
        return tag.getBoolean("pastereplace");
    }

    public static void setToolRange(ItemStack stack, int range) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        tagCompound.putInt("range", range);
    }

    public static int getToolRange(ItemStack stack) {
        CompoundTag tagCompound = stack.getOrCreateTag();
        return Mth.clamp((int)tagCompound.getInt("range"), (int)1, (int)15);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        stack.getOrCreateTag().putInt(valueName, value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return stack.getOrCreateTag().getInt(valueName);
    }

    public static void setTemplateName(ItemStack stack, String name) {
        CompoundTag tag = stack.getOrCreateTag();
        tag.putString("templatename", name);
    }

    public static String getTemplateName(ItemStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        return tag.getString("templatename");
    }

    public static boolean getFuzzy(ItemStack stack) {
        return GadgetNBT.getSetting(stack, "fuzzy");
    }

    public static BaseMode getMode(ItemStack stack) {
        Preconditions.checkArgument((boolean)(stack.getItem() instanceof BaseGadget), (Object)"You can not get a mode of a non-gadget item");
        String mode = stack.getOrCreateTag().getString("mode");
        GadgetTarget gadgetTarget = ((BaseGadget)stack.getItem()).gadgetTarget();
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(gadgetTarget);
        if (mode.isEmpty()) {
            if (stack.getItem() instanceof GadgetBuilding) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"build_to_me")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetExchanger) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"surface")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetCutPaste) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"cut")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetCopyPaste) {
                return modesForGadget.stream().filter(m -> m.getId().equals((Object)"copy")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            return (BaseMode)modesForGadget.first();
        }
        ResourceLocation id = new ResourceLocation(mode);
        return modesForGadget.stream().filter(m -> m.getId().equals((Object)id)).findFirst().orElse((BaseMode)modesForGadget.first());
    }

    public static void setMode(ItemStack gadget, BaseMode mode) {
        gadget.getOrCreateTag().putString("mode", mode.getId().toString());
    }

    public static enum RenderTypes {
        GROW("buildinggadgets2.grow"),
        FADE("buildinggadgets2.fade"),
        SQUISH("buildinggadgets2.squish"),
        GROWUP("buildinggadgets2.growup"),
        RISEUP("buildinggadgets2.riseup"),
        SNAP("buildinggadgets2.snap");

        private final String lang;

        private RenderTypes(String lang) {
            this.lang = lang;
        }

        public RenderTypes next() {
            return RenderTypes.values()[(this.ordinal() + 1) % RenderTypes.values().length];
        }

        public byte getPosition() {
            return (byte)this.ordinal();
        }

        public String getLang() {
            return this.lang;
        }

        public static RenderTypes getByOrdinal(byte ordinal) {
            return RenderTypes.values()[ordinal];
        }
    }

    public static enum NBTValues {
        FUZZY("fuzzy"),
        CONNECTED_AREA("connected_area");

        public final String value;

        private NBTValues(String value) {
            this.value = value;
        }
    }
}

