/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.datatypes;

import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.ItemStackKey;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StatePos {
    public BlockState state;
    public BlockPos pos;

    public StatePos(BlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
    }

    public StatePos(CompoundTag compoundTag) {
        if (!compoundTag.contains("blockstate") || !compoundTag.contains("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)compoundTag.getCompound("blockstate"));
        this.pos = NbtUtils.readBlockPos((CompoundTag)compoundTag.getCompound("blockpos"));
    }

    public StatePos(CompoundTag compoundTag, ArrayList<BlockState> blockStates) {
        if (!compoundTag.contains("blockstateshort") || !compoundTag.contains("blockpos")) {
            this.state = null;
            this.pos = null;
        }
        this.state = blockStates.get(compoundTag.getShort("blockstateshort"));
        this.pos = BlockPos.of((long)compoundTag.getLong("blockpos"));
    }

    public CompoundTag getTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put("blockstate", (Tag)NbtUtils.writeBlockState((BlockState)this.state));
        compoundTag.put("blockpos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.pos));
        return compoundTag;
    }

    public CompoundTag getTag(ArrayList<BlockState> blockStates) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putShort("blockstateshort", (short)blockStates.indexOf(this.state));
        compoundTag.putLong("blockpos", this.pos.asLong());
        return compoundTag;
    }

    public static ArrayList<BlockState> getBlockStateMap(ArrayList<StatePos> list) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (StatePos statePos : list) {
            if (blockStateMap.contains(statePos.state)) continue;
            blockStateMap.add(statePos.state);
        }
        return blockStateMap;
    }

    public static ArrayList<StatePos> rotate90Degrees(ArrayList<StatePos> list, ArrayList<TagPos> tagListMutable) {
        ArrayList<StatePos> rotatedList = new ArrayList<StatePos>();
        if (list == null || list.isEmpty()) {
            return rotatedList;
        }
        boolean tags = tagListMutable != null && !tagListMutable.isEmpty();
        Map<Object, Object> tagMap = new HashMap();
        if (tags) {
            tagMap = tagListMutable.stream().collect(Collectors.toMap(e -> e.pos, e -> e.tag));
        }
        for (StatePos statePos : list) {
            BlockPos oldPos = statePos.pos;
            BlockState oldState = statePos.state;
            BlockState newState = oldState.rotate(Rotation.CLOCKWISE_90);
            BlockPos newPos = new BlockPos(-oldPos.getZ(), oldPos.getY(), oldPos.getX());
            if (tags && tagMap.get(statePos.pos) != null) {
                CompoundTag tempTag = (CompoundTag)tagMap.get(statePos.pos);
                tagMap.remove(statePos.pos);
                tagMap.put(newPos, tempTag);
            }
            rotatedList.add(new StatePos(newState, newPos));
        }
        if (tags) {
            tagListMutable.clear();
            for (Map.Entry entry : tagMap.entrySet()) {
                tagListMutable.add(new TagPos((CompoundTag)entry.getValue(), (BlockPos)entry.getKey()));
            }
        }
        return rotatedList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Map<ItemStackKey, Integer> getItemList(ArrayList<StatePos> list) {
        Object2IntOpenHashMap itemList = new Object2IntOpenHashMap();
        if (list == null || list.isEmpty()) {
            return itemList;
        }
        for (StatePos statePos : list) {
            ItemStackKey itemStackKey = new ItemStackKey(GadgetUtils.getItemForBlock(statePos.state, (Level)Minecraft.getInstance().level, BlockPos.ZERO, (Player)Minecraft.getInstance().player), true);
            if (!itemList.containsKey(itemStackKey)) {
                itemList.put(itemStackKey, 1);
                continue;
            }
            itemList.put(itemStackKey, (Integer)itemList.get(itemStackKey) + 1);
        }
        return itemList;
    }

    public static ListTag getBlockStateNBT(ArrayList<BlockState> blockStateMap) {
        ListTag listTag = new ListTag();
        for (BlockState blockState : blockStateMap) {
            listTag.add((Object)NbtUtils.writeBlockState((BlockState)blockState));
        }
        return listTag;
    }

    public static ArrayList<BlockState> getBlockStateMapFromNBT(ListTag listTag) {
        ArrayList<BlockState> blockStateMap = new ArrayList<BlockState>();
        for (int i = 0; i < listTag.size(); ++i) {
            BlockState blockState = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)listTag.getCompound(i));
            blockStateMap.add(blockState);
        }
        return blockStateMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StatePos) {
            return ((StatePos)obj).state.equals(this.state) && ((StatePos)obj).pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.state, this.pos);
    }
}

