/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class BaseMode
implements Comparable<BaseMode> {
    public boolean isExchanging;

    public BaseMode(boolean isExchanging) {
        this.isExchanging = isExchanging;
    }

    public final ArrayList<StatePos> collect(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        ArrayList<StatePos> buildList = new ArrayList<StatePos>();
        if (!player.mayBuild()) {
            return buildList;
        }
        ArrayList<BlockPos> anchorList = GadgetNBT.getAnchorList(gadget);
        if (anchorList.isEmpty()) {
            buildList.addAll(this.collectWorld(hitSide, player, start, state));
        } else {
            ArrayList<BlockPos> posList = GadgetNBT.getAnchorList(gadget);
            posList.forEach(e -> buildList.add(new StatePos(state, (BlockPos)e)));
        }
        return buildList;
    }

    public abstract ArrayList<StatePos> collectWorld(Direction var1, Player var2, BlockPos var3, BlockState var4);

    public abstract ResourceLocation getId();

    public String i18n() {
        return "buildinggadgets2.modes." + this.getId().getPath();
    }

    public ResourceLocation icon() {
        return new ResourceLocation("buildinggadgets2", "textures/gui/mode/" + this.getId().getPath() + ".png");
    }

    public boolean isPosValid(Level level, Player player, BlockPos blockPos, BlockState blockState) {
        ItemStack gadget = BaseGadget.getGadget(player);
        if (!this.isExchangingValid(level, player, blockPos, gadget)) {
            return false;
        }
        if (blockPos.getY() >= level.getMaxBuildHeight() || blockPos.getY() < level.getMinBuildHeight()) {
            return false;
        }
        if (!blockState.canSurvive((LevelReader)level, blockPos)) {
            return false;
        }
        if (!level.mayInteract(player, blockPos)) {
            return false;
        }
        return this.isExchanging || level.getBlockState(blockPos).canBeReplaced();
    }

    public ArrayList<StatePos> removeUnConnected(Level level, Player player, BlockPos startAt, ArrayList<StatePos> coordinates, Direction hitSide) {
        if (coordinates.isEmpty()) {
            return coordinates;
        }
        Map<BlockPos, BlockState> coordinatesPositions = coordinates.stream().collect(Collectors.toMap(e -> e.pos, e -> e.state));
        HashSet<StatePos> visitedBlocks = new HashSet<StatePos>();
        LinkedList<BlockPos> blocksToVisit = new LinkedList<BlockPos>();
        blocksToVisit.offer(startAt);
        while (!blocksToVisit.isEmpty()) {
            BlockPos currentPos = (BlockPos)blocksToVisit.poll();
            if (visitedBlocks.contains(new StatePos(coordinatesPositions.get(currentPos), currentPos)) || !coordinatesPositions.containsKey(currentPos)) continue;
            visitedBlocks.add(new StatePos(coordinatesPositions.get(currentPos), currentPos));
            for (Direction direction : Direction.stream().filter(e -> !e.getAxis().equals((Object)hitSide.getAxis())).toList()) {
                BlockPos nextPos = currentPos.relative(direction);
                if (!coordinatesPositions.containsKey(nextPos)) continue;
                blocksToVisit.offer(nextPos);
            }
        }
        return new ArrayList<StatePos>(visitedBlocks);
    }

    public boolean isExchangingValid(Level level, Player player, BlockPos pos, ItemStack gadget) {
        if (!this.isExchanging) {
            return true;
        }
        if (level.getBlockState(pos).isAir()) {
            return false;
        }
        if (!GadgetUtils.isValidBlockState(level.getBlockState(pos), level, pos)) {
            return false;
        }
        boolean fuzzy = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.FUZZY.value);
        BlockState oldState = level.getBlockState(pos);
        if (oldState.hasBlockEntity() && !GadgetNBT.getSetting(gadget, "affecttiles")) {
            return false;
        }
        if (fuzzy) {
            if (oldState.isAir()) {
                return false;
            }
            if (oldState.equals(GadgetNBT.getGadgetBlockState(gadget))) {
                return false;
            }
            if (oldState.getBlock() instanceof RenderBlock) {
                return false;
            }
        } else {
            BlockHitResult lookingAt = VectorHelper.getLookingAt(player, gadget);
            BlockState compareState = level.getBlockState(lookingAt.getBlockPos());
            if (!oldState.equals(compareState)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(@NotNull BaseMode o) {
        return this.getId().compareTo(o.getId());
    }
}

