/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class HorizontalRow
extends BaseMode {
    public HorizontalRow(boolean exchanging) {
        super(exchanging);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "horizontal_row");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        Direction side;
        ItemStack gadget = BaseGadget.getGadget(player);
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        int range = GadgetNBT.getToolRange(gadget);
        boolean placeontop = GadgetNBT.getSetting(gadget, "placeontop");
        BlockPos startAt = placeontop ? start.above() : start;
        Direction direction = side = hitSide.getAxis() == Direction.Axis.Y ? player.getDirection() : hitSide.getOpposite();
        if (!this.isExchanging) {
            for (int i = 0; i < range; ++i) {
                if (!this.isPosValid(player.level(), player, startAt.relative(side, i), state)) continue;
                coordinates.add(new StatePos(state, startAt.relative(side, i).subtract((Vec3i)start)));
            }
        } else {
            side = side.getClockWise();
            int halfRange = range / 2;
            for (int i = -halfRange; i <= halfRange; ++i) {
                if (!this.isPosValid(player.level(), player, startAt.relative(side, i), state)) continue;
                coordinates.add(new StatePos(state, startAt.relative(side, i).subtract((Vec3i)start)));
            }
        }
        boolean connected = GadgetNBT.getSetting(gadget, GadgetNBT.NBTValues.CONNECTED_AREA.value);
        if (this.isExchanging && connected) {
            return this.removeUnConnected(player.level(), player, startAt.subtract((Vec3i)start), coordinates, hitSide);
        }
        return coordinates;
    }
}

