/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class Stairs
extends BaseMode {
    public Stairs() {
        super(false);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "stairs");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        ItemStack gadget = BaseGadget.getGadget(player);
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        boolean placeOnTop = GadgetNBT.getSetting(gadget, "placeontop");
        Direction side = hitSide;
        if (hitSide.getAxis() == Direction.Axis.Y) {
            side = player.getDirection().getOpposite();
        }
        int range = GadgetNBT.getToolRange(gadget);
        for (int i = 0; i < range; ++i) {
            int shiftAxis = (i + 1) * (hitSide == Direction.EAST || hitSide == Direction.SOUTH ? 1 : -1);
            if ((double)start.getY() < player.getY() && hitSide.getAxis().isHorizontal()) {
                boolean mutateXAxis = hitSide.getAxis() == Direction.Axis.X;
                boolean mutateZAxis = hitSide.getAxis() == Direction.Axis.Z;
                BlockPos coord = start.offset(mutateXAxis ? shiftAxis : 0, placeOnTop ? -i : -(i + 1), mutateZAxis ? shiftAxis : 0);
                if (!this.isPosValid(player.level(), player, coord, state)) continue;
                coordinates.add(new StatePos(state, coord.subtract((Vec3i)start)));
                continue;
            }
            shiftAxis = i * (side == Direction.EAST || side == Direction.SOUTH ? -1 : 1);
            if ((double)start.getY() < player.getY() - 2.0) {
                shiftAxis *= -1;
            }
            BlockPos coord = start.offset(side.getAxis() == Direction.Axis.X ? shiftAxis : 0, ((double)start.getY() > player.getY() + 1.0 ? i * -1 : i) + (placeOnTop ? 1 : 0), side.getAxis() == Direction.Axis.Z ? shiftAxis : 0);
            if (!this.isPosValid(player.level(), player, coord, state)) continue;
            coordinates.add(new StatePos(state, coord.subtract((Vec3i)start)));
        }
        return coordinates;
    }
}

