/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util.modes;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class VerticalWall
extends BaseMode {
    public VerticalWall() {
        super(false);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("buildinggadgets2", "vertical_wall");
    }

    @Override
    public ArrayList<StatePos> collectWorld(Direction hitSide, Player player, BlockPos start, BlockState state) {
        int startY;
        ItemStack gadget = BaseGadget.getGadget(player);
        int range = GadgetNBT.getToolRange(gadget);
        int size = range / 2;
        ArrayList<StatePos> coordinates = new ArrayList<StatePos>();
        Direction.Axis side = hitSide.getAxis() == Direction.Axis.Y ? player.getDirection().getOpposite().getAxis() : hitSide.getAxis();
        int n = startY = hitSide.getAxis() == Direction.Axis.Y ? start.getY() + 1 : start.getY() - size;
        int endY = hitSide.getAxis() == Direction.Axis.Y ? start.getY() + (range - 1) * (hitSide == Direction.DOWN ? -1 : 1) + 1 : start.getY() + size;
        AABB box = new AABB((double)(start.getX() - (side == Direction.Axis.Z ? size : 0)), (double)startY, (double)(start.getZ() - (side == Direction.Axis.X ? size : 0)), (double)(start.getX() + (side == Direction.Axis.Z ? size : 0)), (double)endY, (double)(start.getZ() + (side == Direction.Axis.X ? size : 0)));
        BlockPos.betweenClosedStream((AABB)box).map(BlockPos::immutable).forEach(pos -> {
            if (this.isPosValid(player.level(), player, (BlockPos)pos, state)) {
                coordinates.add(new StatePos(state, pos.subtract((Vec3i)start)));
            }
        });
        return coordinates;
    }
}

