/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CandleProcessor
extends StructureProcessor {
    public static final CandleProcessor INSTANCE = new CandleProcessor();
    public static final Codec<CandleProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static final List<Block> CANDLES = List.of(Blocks.CANDLE, Blocks.WHITE_CANDLE, Blocks.GRAY_CANDLE, Blocks.LIGHT_GRAY_CANDLE, Blocks.BROWN_CANDLE, Blocks.GREEN_CANDLE, Blocks.PURPLE_CANDLE, Blocks.BLACK_CANDLE);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() instanceof SeaPickleBlock) {
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            int numCandles = random.nextInt(4) + 1;
            boolean lit = random.nextFloat() < 0.1f;
            BlockState newBlockState = (BlockState)((BlockState)CandleProcessor.getRandomCandle(random).defaultBlockState().setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(numCandles))).setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(lit));
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), newBlockState, blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    private static Block getRandomCandle(RandomSource random) {
        int i = random.nextInt(CANDLES.size());
        return CANDLES.get(i);
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.CANDLE_PROCESSOR;
    }
}

