/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_nether_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonContext;
import com.yungnickyoung.minecraft.betterdungeons.world.DungeonType;
import com.yungnickyoung.minecraft.yungsapi.world.banner.Banner;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SmallNetherDungeonBannerProcessor
extends StructureProcessor {
    public static final Codec<SmallNetherDungeonBannerProcessor> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.STRING.fieldOf("dungeon_type").forGetter(processor -> processor.getDungeonType().getName())).apply((Applicative)codecBuilder, codecBuilder.stable(SmallNetherDungeonBannerProcessor::new)));
    private final DungeonType dungeonType;
    public static final Banner SKELETON_BANNER = new Banner.Builder().blockState(Blocks.BLACK_WALL_BANNER.defaultBlockState()).pattern("cbo", 0).pattern("cs", 0).pattern("bs", 15).pattern("ts", 0).pattern("cre", 0).pattern("gra", 15).customName("Vengeful Banner").customColor("dark_gray").build();
    public static final Banner WITHER_SKELETON_BANNER = new Banner.Builder().blockState(Blocks.RED_WALL_BANNER.defaultBlockState()).pattern("cbo", 15).pattern("cs", 15).pattern("bs", 14).pattern("cre", 15).pattern("ts", 15).pattern("gru", 15).customName("Banner of Decay").customColor("dark_purple").build();
    public static final Banner ZOMBIFIED_PIGLIN_BANNER = new Banner.Builder().blockState(Blocks.PINK_WALL_BANNER.defaultBlockState()).pattern("ls", 13).pattern("tts", 15).pattern("tts", 6).pattern("cs", 6).pattern("vhr", 8).pattern("rd", 13).pattern("cre", 0).pattern("hhb", 6).pattern("mr", 6).pattern("pig", 15).pattern("gru", 6).pattern("bs", 15).customName("Banner of Pork").customColor("light_purple").build();
    public static final Banner BLAZE_BANNER = new Banner.Builder().blockState(Blocks.RED_WALL_BANNER.defaultBlockState()).pattern("ss", 4).pattern("tt", 14).pattern("tt", 14).pattern("flo", 1).pattern("sku", 4).pattern("cbo", 14).pattern("gru", 15).customName("Banner of Rage").customColor("gold").build();

    private SmallNetherDungeonBannerProcessor(String dungeonType) {
        this.dungeonType = DungeonType.fromString(dungeonType);
    }

    public DungeonType getDungeonType() {
        return this.dungeonType;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() instanceof AbstractBannerBlock && blockInfoGlobal.state().getBlock() == Blocks.GRAY_WALL_BANNER && (blockInfoGlobal.nbt().get("Patterns") == null || blockInfoGlobal.nbt().getList("Patterns", 10).size() == 0)) {
            DungeonContext context = DungeonContext.peek();
            if (context.getBannerCount() >= BetterDungeonsCommon.CONFIG.smallNetherDungeons.bannerMaxCount) {
                return new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), blockInfoGlobal.nbt());
            }
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            if (random.nextFloat() > 0.1f) {
                return new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.AIR.defaultBlockState(), blockInfoGlobal.nbt());
            }
            Banner banner = this.getBannerForType();
            Direction facing = (Direction)blockInfoGlobal.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockState newState = (BlockState)banner.getState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing);
            CompoundTag newNBT = this.copyNBT(banner.getNbt());
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), newState, newNBT);
            context.incrementBannerCount();
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.SMALL_NETHER_DUNGEON_BANNER_PROCESSOR;
    }

    private Banner getBannerForType() {
        switch (this.dungeonType) {
            case SKELETON: {
                return SKELETON_BANNER;
            }
            case ZOMBIFIED_PIGLIN: {
                return ZOMBIFIED_PIGLIN_BANNER;
            }
            case WITHER_SKELETON: {
                return WITHER_SKELETON_BANNER;
            }
            case BLAZE: {
                return BLAZE_BANNER;
            }
        }
        BetterDungeonsCommon.LOGGER.warn("Invalid DungeonType {} for small_nether_dungeon_banner_processor! This shouldn't happen!", (Object)this.dungeonType);
        return SKELETON_BANNER;
    }

    private CompoundTag copyNBT(CompoundTag other) {
        CompoundTag nbt = new CompoundTag();
        nbt.merge(other);
        return nbt;
    }
}

