/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.small_nether_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.world.spawner.MobSpawnerData;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SmallNetherDungeonMobSpawner
extends StructureProcessor {
    public static final Codec<SmallNetherDungeonMobSpawner> CODEC = RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)ResourceLocation.CODEC.fieldOf("spawner_mob").forGetter(SmallNetherDungeonMobSpawner::getSpawnerMob)).apply((Applicative)codecBuilder, codecBuilder.stable(SmallNetherDungeonMobSpawner::new)));
    private final ResourceLocation spawnerMob;

    private SmallNetherDungeonMobSpawner(ResourceLocation spawnerMob) {
        this.spawnerMob = spawnerMob;
    }

    public ResourceLocation getSpawnerMob() {
        return this.spawnerMob;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().getBlock() instanceof SpawnerBlock) {
            MobSpawnerData spawner = MobSpawnerData.builder().spawnPotentials(SimpleWeightedRandomList.single((Object)new SpawnData((CompoundTag)Util.make((Object)new CompoundTag(), compoundTag -> {
                compoundTag.putString("id", this.spawnerMob.toString());
                if (this.spawnerMob.toString().equals("minecraft:wither_skeleton")) {
                    compoundTag.put("ArmorItems", (Tag)Util.make((Object)new ListTag(), armorItemsNbt -> {
                        ItemStack itemStack = new ItemStack((ItemLike)Items.NETHERITE_BOOTS);
                        CompoundTag bootsNbt = new CompoundTag();
                        itemStack.save(bootsNbt);
                        armorItemsNbt.add((Object)bootsNbt);
                        itemStack = new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS);
                        CompoundTag leggingsNbt = new CompoundTag();
                        itemStack.save(leggingsNbt);
                        armorItemsNbt.add((Object)leggingsNbt);
                        itemStack = new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE);
                        CompoundTag chestNbt = new CompoundTag();
                        itemStack.save(chestNbt);
                        armorItemsNbt.add((Object)chestNbt);
                        itemStack = new ItemStack((ItemLike)Items.NETHERITE_HELMET);
                        CompoundTag helmetNbt = new CompoundTag();
                        itemStack.save(helmetNbt);
                        armorItemsNbt.add((Object)helmetNbt);
                    }));
                    compoundTag.put("ArmorDropChances", (Tag)Util.make((Object)new ListTag(), armorDropChancesNbt -> {
                        armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                        armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                        armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                        armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                    }));
                    compoundTag.put("HandItems", (Tag)Util.make((Object)new ListTag(), handItemsNbt -> {
                        ItemStack itemStack = new ItemStack((ItemLike)Items.STONE_SWORD);
                        CompoundTag stoneSwordNbt = new CompoundTag();
                        itemStack.save(stoneSwordNbt);
                        handItemsNbt.add((Object)stoneSwordNbt);
                    }));
                    if (!BetterDungeonsCommon.CONFIG.smallNetherDungeons.witherSkeletonsDropWitherSkulls) {
                        compoundTag.putString("DeathLootTable", "minecraft:empty");
                    }
                } else if (this.spawnerMob.toString().equals("minecraft:blaze") && !BetterDungeonsCommon.CONFIG.smallNetherDungeons.blazesDropBlazeRods) {
                    compoundTag.putString("DeathLootTable", "minecraft:empty");
                }
            }), Optional.empty()))).setEntityType((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.spawnerMob)).build();
            if (this.spawnerMob.toString().equals("minecraft:wither_skeleton")) {
                spawner.nextSpawnData.getEntityToSpawn().put("ArmorItems", (Tag)Util.make((Object)new ListTag(), armorItemsNbt -> {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.NETHERITE_BOOTS);
                    CompoundTag bootsNbt = new CompoundTag();
                    itemStack.save(bootsNbt);
                    armorItemsNbt.add((Object)bootsNbt);
                    itemStack = new ItemStack((ItemLike)Items.NETHERITE_LEGGINGS);
                    CompoundTag leggingsNbt = new CompoundTag();
                    itemStack.save(leggingsNbt);
                    armorItemsNbt.add((Object)leggingsNbt);
                    itemStack = new ItemStack((ItemLike)Items.NETHERITE_CHESTPLATE);
                    CompoundTag chestNbt = new CompoundTag();
                    itemStack.save(chestNbt);
                    armorItemsNbt.add((Object)chestNbt);
                    itemStack = new ItemStack((ItemLike)Items.NETHERITE_HELMET);
                    CompoundTag helmetNbt = new CompoundTag();
                    itemStack.save(helmetNbt);
                    armorItemsNbt.add((Object)helmetNbt);
                }));
                spawner.nextSpawnData.getEntityToSpawn().put("ArmorDropChances", (Tag)Util.make((Object)new ListTag(), armorDropChancesNbt -> {
                    armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                    armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                    armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                    armorDropChancesNbt.add((Object)FloatTag.valueOf((float)0.0f));
                }));
                spawner.nextSpawnData.getEntityToSpawn().put("HandItems", (Tag)Util.make((Object)new ListTag(), handItemsNbt -> {
                    ItemStack itemStack = new ItemStack((ItemLike)Items.STONE_SWORD);
                    CompoundTag stoneSwordNbt = new CompoundTag();
                    itemStack.save(stoneSwordNbt);
                    handItemsNbt.add((Object)stoneSwordNbt);
                }));
                if (!BetterDungeonsCommon.CONFIG.smallNetherDungeons.witherSkeletonsDropWitherSkulls) {
                    spawner.nextSpawnData.getEntityToSpawn().putString("DeathLootTable", "minecraft:empty");
                }
            } else if (this.spawnerMob.toString().equals("minecraft:blaze") && !BetterDungeonsCommon.CONFIG.smallNetherDungeons.blazesDropBlazeRods) {
                spawner.nextSpawnData.getEntityToSpawn().putString("DeathLootTable", "minecraft:empty");
            }
            CompoundTag nbt = spawner.save();
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.SPAWNER.defaultBlockState(), nbt);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.SMALL_NETHER_DUNGEON_MOB_SPAWNER_PROCESSOR;
    }
}

