/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureTypeModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonBigTunnelPiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class SpiderDungeonStructure
extends Structure {
    public static final Codec<SpiderDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)SpiderDungeonStructure.settingsCodec((RecordCodecBuilder.Instance)builder), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight)).apply((Applicative)builder, SpiderDungeonStructure::new));
    private final HeightProvider startHeight;

    public SpiderDungeonStructure(Structure.StructureSettings structureSettings, HeightProvider startHeight) {
        super(structureSettings);
        this.startHeight = startHeight;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        int startX = context.chunkPos().getMiddleBlockX();
        int startZ = context.chunkPos().getMiddleBlockZ();
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        BlockPos startPos = new BlockPos(startX, startY, startZ);
        SpiderDungeonBigTunnelPiece startPiece = new SpiderDungeonBigTunnelPiece(startPos);
        StructurePiecesBuilder structurePiecesBuilder = new StructurePiecesBuilder();
        structurePiecesBuilder.addPiece((StructurePiece)startPiece);
        startPiece.addChildren(startPiece, (StructurePieceAccessor)structurePiecesBuilder, (RandomSource)context.random());
        return Optional.of(new Structure.GenerationStub(startPos, Either.right((Object)structurePiecesBuilder)));
    }

    public StructureType<?> type() {
        return StructureTypeModule.SPIDER_DUNGEON;
    }
}

