/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import xyz.vsngamer.elevatorid.blocks.ElevatorBlock;
import xyz.vsngamer.elevatorid.init.ModConfig;
import xyz.vsngamer.elevatorid.network.TeleportHandler;
import xyz.vsngamer.elevatorid.network.TeleportRequest;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elevatorid")
public class ElevatorHandler {
    private static boolean lastSneaking;
    private static boolean lastJumping;

    @SubscribeEvent
    public static void onInput(InputEvent.Key event) {
        ElevatorHandler.handleInput();
    }

    @SubscribeEvent
    private static void onMouseInput(InputEvent.MouseButton.Post event) {
        ElevatorHandler.handleInput();
    }

    private static void handleInput() {
        boolean jumping;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || player.isSpectator() || !player.isAlive() || player.input == null) {
            return;
        }
        boolean sneaking = player.input.shiftKeyDown;
        if (lastSneaking != sneaking) {
            lastSneaking = sneaking;
            if (sneaking) {
                ElevatorHandler.tryTeleport(player, Direction.DOWN);
            }
        }
        if (lastJumping != (jumping = player.input.jumping)) {
            lastJumping = jumping;
            if (jumping) {
                ElevatorHandler.tryTeleport(player, Direction.UP);
            }
        }
    }

    private static void tryTeleport(LocalPlayer player, Direction facing) {
        block2: {
            ElevatorBlock toElevator;
            Level world = player.level();
            BlockPos fromPos = ElevatorHandler.getOriginElevator(player);
            if (fromPos == null) {
                return;
            }
            BlockPos.MutableBlockPos toPos = fromPos.mutable();
            ElevatorBlock fromElevator = (ElevatorBlock)world.getBlockState(fromPos).getBlock();
            do {
                toPos.setY(toPos.getY() + facing.getStepY());
                if (world.isOutsideBuildHeight((BlockPos)toPos) || Math.abs(toPos.getY() - fromPos.getY()) > (Integer)ModConfig.GENERAL.range.get()) break block2;
            } while ((toElevator = TeleportHandler.getElevator(world.getBlockState((BlockPos)toPos))) == null || !TeleportHandler.isValidPos((BlockGetter)world, (BlockPos)toPos) || ((Boolean)ModConfig.GENERAL.sameColor.get()).booleanValue() && fromElevator.getColor() != toElevator.getColor());
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new TeleportRequest(fromPos, (BlockPos)toPos)});
        }
    }

    private static BlockPos getOriginElevator(LocalPlayer player) {
        Level world = player.level();
        BlockPos pos = player.blockPosition();
        for (int i = 0; i < 3; ++i) {
            if (TeleportHandler.getElevator(world.getBlockState(pos)) != null) {
                return pos;
            }
            pos = pos.below();
        }
        return null;
    }
}

