/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevatorid.network;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import xyz.vsngamer.elevatorid.network.TeleportHandler;
import xyz.vsngamer.elevatorid.network.TeleportRequest;
import xyz.vsngamer.elevatorid.network.client.RemoveCamoPacket;
import xyz.vsngamer.elevatorid.network.client.SetArrowPacket;
import xyz.vsngamer.elevatorid.network.client.SetDirectionalPacket;
import xyz.vsngamer.elevatorid.network.client.SetFacingPacket;
import xyz.vsngamer.elevatorid.tile.ElevatorContainer;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("elevatorid").versioned("1.0.0");
        registrar.play(TeleportRequest.ID, TeleportRequest::new, handler -> handler.server(TeleportHandler.getInstance()::handle));
        registrar.play(SetDirectionalPacket.ID, SetDirectionalPacket::new, handler -> handler.server(SetDirectionalPacket.Handler.getInstance()::handle));
        registrar.play(SetArrowPacket.ID, SetArrowPacket::new, handler -> handler.server(SetArrowPacket.Handler.getInstance()::handle));
        registrar.play(RemoveCamoPacket.ID, RemoveCamoPacket::new, handler -> handler.server(RemoveCamoPacket.Handler.getInstance()::handle));
        registrar.play(SetFacingPacket.ID, SetFacingPacket::new, handler -> handler.server(SetFacingPacket.Handler.getInstance()::handle));
    }

    public static boolean isBadClientPacket(Player player, BlockPos pos) {
        if (player == null || player.isDeadOrDying() || player.isRemoved()) {
            return true;
        }
        Level world = player.level();
        if (!world.isLoaded(pos)) {
            return true;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof ElevatorContainer)) {
            return true;
        }
        ElevatorContainer container = (ElevatorContainer)abstractContainerMenu;
        return !container.getPos().equals((Object)pos);
    }
}

