/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.init.ModRegistry;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PodzolBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PopResourceBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModConstructor {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"universalbonemeal").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        UniversalBoneMeal.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealCallback.EVENT.register(BonemealHandler::onBonemeal);
        TagsUpdatedCallback.EVENT.register((registryAccess, client) -> {
            if (client) {
                return;
            }
            BonemealHandler.invalidate();
            CoralBehavior.invalidate();
        });
    }

    public void onCommonSetup() {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(Blocks.CACTUS, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCactus);
        BonemealHandler.registerBehavior(Blocks.SUGAR_CANE, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSugarCane);
        BonemealHandler.registerBehavior(Blocks.VINE, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowVines);
        BonemealHandler.registerBehavior(Blocks.NETHER_WART, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowNetherWart);
        BonemealHandler.registerBehavior(Set.of(Blocks.MELON_STEM, Blocks.PUMPKIN_STEM), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowFruitStems);
        BonemealHandler.registerBehavior(Blocks.LILY_PAD, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowLilyPad);
        BonemealHandler.registerBehavior(Blocks.DEAD_BUSH, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDeadBush);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.FLOWERS, ModRegistry.FERTILIZER_RESISTANT_FLOWER_BLOCK_TAG, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSmallFlowers);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.CORAL_PLANTS, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCorals);
        BonemealHandler.registerBehavior(Blocks.CHORUS_FLOWER, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.CHORUS_PLANT, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.MYCELIUM, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowMycelium);
        BonemealHandler.registerBehavior(Set.of(Blocks.DIRT, Blocks.COARSE_DIRT, Blocks.DIRT_PATH), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDirt);
        BonemealHandler.registerBehavior(Blocks.PODZOL, PodzolBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowPodzol);
        BonemealHandler.registerBehavior(Blocks.SPORE_BLOSSOM, () -> new PopResourceBehavior(Direction.DOWN), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSporeBlossom);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

