/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.core.CommonAbstractions;
import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitStemBehavior
implements BonemealBehavior {
    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!state.hasProperty((Property)StemBlock.AGE) || (Integer)state.getValue((Property)StemBlock.AGE) != 7) {
            return false;
        }
        return Direction.Plane.HORIZONTAL.stream().anyMatch(direction -> this.canSustainPlant(level, pos, state, (Direction)direction));
    }

    private boolean canSustainPlant(LevelReader level, BlockPos sourcePos, BlockState sourceBlock, Direction direction) {
        BlockPos blockpos = sourcePos.relative(direction);
        BlockState blockstate = level.getBlockState(blockpos.below());
        Block block = blockstate.getBlock();
        return level.isEmptyBlock(blockpos) && (CommonAbstractions.INSTANCE.canSustainPlant(blockstate, (BlockGetter)level, blockpos.below(), Direction.UP, sourceBlock.getBlock()) || block == Blocks.FARMLAND || block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.PODZOL || block == Blocks.GRASS_BLOCK);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        while (level.getBlockState(pos) == state && random.nextInt(3) != 0) {
            state.randomTick(level, pos, random);
        }
    }
}

