/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather;

import java.time.LocalDate;
import java.time.Month;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.joml.Vector3f;
import tv.soaryn.simpleweather.ParticleContent;
import tv.soaryn.simpleweather.SimpleWeather;
import tv.soaryn.simpleweather.particles.RainParticle;
import tv.soaryn.simpleweather.particles.SnowParticle;

public class SimpleWeatherClient {
    public static LocalDate Now = LocalDate.now();
    public static boolean IsFools = false;

    @Mod.EventBusSubscriber(modid="simple_weather", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    private static interface NeoBus {
        @SubscribeEvent
        private static void updateTime(LevelEvent.Load event) {
            Now = LocalDate.now();
            IsFools = Now.getDayOfMonth() == 1 && Now.getMonth() == Month.APRIL;
        }

        @SubscribeEvent
        public static void renderWeather(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                return;
            }
            boolean isEnabled = (Boolean)SimpleWeather.ClientConfig.OverrideWeather.get();
            if (!isEnabled) {
                return;
            }
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            LocalPlayer player = minecraft.player;
            if (level == null || player == null) {
                return;
            }
            TickRateManager tickRateManager = level.tickRateManager();
            if (minecraft.isPaused() || !tickRateManager.runsNormally()) {
                return;
            }
            float partialTick = minecraft.getPartialTick();
            BlockPos pos = minecraft.gameRenderer.getMainCamera().getBlockPosition();
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            Vector3f velocity = player.getDeltaMovement().toVector3f().mul(32.0f);
            int vx = (int)((float)x + velocity.x);
            int vz = (int)((float)z + velocity.z);
            int n = (Integer)SimpleWeather.ClientConfig.WeatherParticleAmount.get();
            int amount = n / (switch ((ParticleStatus)minecraft.options.particles().get()) {
                default -> throw new IncompatibleClassChangeError();
                case ParticleStatus.ALL -> 1;
                case ParticleStatus.DECREASED -> 2;
                case ParticleStatus.MINIMAL -> 4;
            });
            int rainRange = (Integer)SimpleWeather.ClientConfig.RainRange.get();
            int snowRange = (Integer)SimpleWeather.ClientConfig.SnowRange.get();
            int snowOuterRange = (Integer)SimpleWeather.ClientConfig.SnowOuterRange.get();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int j = 0; j < amount; ++j) {
                NeoBus.addRain(level, vx, y, vz, mutablePos, rainRange, partialTick);
                NeoBus.addSnowflake(level, vx, y, vz, mutablePos, snowRange, partialTick);
                NeoBus.addSnowflake(level, vx, y, vz, mutablePos, snowOuterRange, partialTick);
            }
        }

        public static void addRain(ClientLevel level, int x, int y, int z, BlockPos.MutableBlockPos pos, int range, float partialTick) {
            if (level.random.nextFloat() > 0.00625f) {
                return;
            }
            if (level.getRainLevel(partialTick) <= 0.0f) {
                return;
            }
            pos.set(x + level.random.nextIntBetweenInclusive(-range, range), y + 24, z + level.random.nextIntBetweenInclusive(-range, range));
            int field = 3;
            if (Mth.abs((int)(pos.getX() - x)) < field && Mth.abs((int)(pos.getZ() - z)) < field) {
                return;
            }
            if (NeoBus.shouldNotPrecipitateAt(level, pos, Biome.Precipitation.RAIN)) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleContent.Rain.get(), true, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + level.random.nextDouble(), (double)pos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
        }

        private static boolean shouldNotPrecipitateAt(ClientLevel level, BlockPos.MutableBlockPos pos, Biome.Precipitation precipitation) {
            if (level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, (BlockPos)pos).getY() > pos.getY()) {
                return true;
            }
            if (!level.canSeeSky((BlockPos)pos)) {
                return true;
            }
            if (level.getBlockState((BlockPos)pos).isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos)) {
                return true;
            }
            return ((Biome)level.getBiomeManager().getNoiseBiomeAtPosition((BlockPos)pos).value()).getPrecipitationAt((BlockPos)pos) != precipitation;
        }

        public static void addSnowflake(ClientLevel level, int x, int y, int z, BlockPos.MutableBlockPos pos, int range, float partialTick) {
            if (level.random.nextFloat() > 0.00625f) {
                return;
            }
            if (level.getRainLevel(partialTick) <= 0.0f) {
                return;
            }
            pos.set(x + level.random.nextIntBetweenInclusive(-range, range), y + level.random.nextIntBetweenInclusive(-range, range), z + level.random.nextIntBetweenInclusive(-range, range));
            if (NeoBus.shouldNotPrecipitateAt(level, pos, Biome.Precipitation.SNOW)) {
                return;
            }
            level.addParticle((ParticleOptions)ParticleContent.Snow.get(), true, (double)pos.getX() + level.random.nextDouble(), (double)pos.getY() + level.random.nextDouble(), (double)pos.getZ() + level.random.nextDouble(), 0.0, 0.0, 0.0);
        }

        public static class Data {
            public static int lastTick = 0;
        }
    }

    @Mod.EventBusSubscriber(modid="simple_weather", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    private static interface ModBus {
        @SubscribeEvent
        private static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleContent.Snow.get(), SnowParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ParticleContent.Rain.get(), RainParticle.Provider::new);
        }
    }
}

