/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather;

import java.nio.file.Path;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;

public class SimpleWeatherConfig {
    private final ModConfig.Type _type = ModConfig.Type.CLIENT;
    private final ModConfigSpec _configs;
    public final ModConfigSpec.BooleanValue OverrideWeather;
    public final ModConfigSpec.IntValue WeatherParticleAmount;
    public final ModConfigSpec.DoubleValue RainScale;
    public final ModConfigSpec.DoubleValue RainAlpha;
    public final ModConfigSpec.IntValue RainLifetime;
    public final ModConfigSpec.IntValue RainRange;
    public final ModConfigSpec.BooleanValue RainHasRandom;
    public final ModConfigSpec.IntValue RainCollisionPercent;
    public final ModConfigSpec.DoubleValue SnowScale;
    public final ModConfigSpec.DoubleValue SnowAlpha;
    public final ModConfigSpec.IntValue SnowLifetime;
    public final ModConfigSpec.IntValue SnowRange;
    public final ModConfigSpec.IntValue SnowOuterRange;

    public SimpleWeatherConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.OverrideWeather = builder.comment("An alternative render to weather").define("override_weather", true);
        this.WeatherParticleAmount = builder.comment("The how many particles will have a chance to spawn in a given tick. This will be affected by in game Minecraft options as well, so be aware if changing. You may also ask, why is this not separate for rain and snow, and that is simply due to the way the loop works at the moment so we don't do 2 different large loops").defineInRange("weather_particle_count", 4000, 100, 20000);
        builder.push("Rain");
        this.RainAlpha = builder.comment("The opacity of the rain particle. (1 is fully opaque)").defineInRange("rain_particle_alpha", 0.8, 0.2, 1.0);
        this.RainScale = builder.comment("Base scaling of the rain particle.").defineInRange("rain_particle_scale", 1.65, 0.1, 4.0);
        this.RainLifetime = builder.comment("How long can a single rain particle live for without hitting the ground.").defineInRange("rain_lifetime", 70, 10, 120);
        this.RainRange = builder.comment("How far from the player should rain particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("rain_range", 22, 5, 64);
        this.RainHasRandom = builder.comment("Determines if the rain should fall deterministically down, or have a slight random appearance").define("random_rain", true);
        this.RainCollisionPercent = builder.comment("How often can a rain particle \"collide\" with the ground").defineInRange("rain_collision_percent", 100, 0, 100);
        builder.pop();
        builder.push("Snow");
        this.SnowAlpha = builder.comment("The opacity of the rain particle. (1 is fully opaque)").defineInRange("snow_particle_alpha", 1.0, 0.2, 1.0);
        this.SnowScale = builder.comment("Changes the base scaling of the rain particle.").defineInRange("snow_particle_scale", (double)1.4f, 0.1, 4.0);
        this.SnowLifetime = builder.comment("How long can a single snow particle live for without hitting the ground.").defineInRange("snow_lifetime", 30, 10, 100);
        this.SnowRange = builder.comment("How far from the player should snow particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("snow_range", 12, 5, 64);
        this.SnowOuterRange = builder.comment("How far from the player should the secondary layer of snow particles spawn. Lowering this number will increase the density if the weather amount is not changed").defineInRange("snow_outer_range", 16, 5, 64);
        builder.pop();
        this._configs = builder.build();
    }

    public void register(ModLoadingContext context) {
        FMLPaths.getOrCreateGameRelativePath((Path)FMLPaths.CONFIGDIR.get());
        context.registerConfig(this._type, (IConfigSpec)this._configs, "%s-%s.toml".formatted("simple_weather", this._type.extension()));
    }
}

