/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.simpleweather.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Predicate;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BaseAshSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import tv.soaryn.simpleweather.ColorUtils;
import tv.soaryn.simpleweather.SimpleWeather;
import tv.soaryn.simpleweather.SimpleWeatherClient;

@OnlyIn(value=Dist.CLIENT)
public class RainParticle
extends BaseAshSmokeParticle {
    private final Vector4f color = new Vector4f();
    private final Vector4f prevColor = new Vector4f();
    private final IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)Fluids.WATER);
    private final boolean isRandom;
    @NotNull
    private SingleQuadParticle.FacingCameraMode orientTowardsVelocity;
    private final BlockPos.MutableBlockPos pos;

    protected RainParticle(ClientLevel level, double xo, double yo, double zo, double vx, double vy, double vz, float scale, SpriteSet sprites) {
        super(level, xo, yo, zo, 0.1f, -0.2f, 0.1f, vx, vy, vz, scale, sprites, 0.0f, ((Integer)SimpleWeather.ClientConfig.RainLifetime.get()).intValue(), 0.0125f, true);
        this.isRandom = (Boolean)SimpleWeather.ClientConfig.RainHasRandom.get();
        this.pos = new BlockPos.MutableBlockPos();
        this.color.set((Vector4fc)this.getTintColor());
        this.color.mul(0.8f);
        this.prevColor.set((Vector4fc)this.color);
        this.friction = 1.0f;
        this.rCol = this.color.x;
        this.gCol = this.color.y;
        this.bCol = this.color.z;
        this.alpha = ((Double)SimpleWeather.ClientConfig.RainAlpha.get()).floatValue();
        this.scale(((Double)SimpleWeather.ClientConfig.RainScale.get()).floatValue());
        this.yd += (double)this.random.nextFloat() * -0.2 - (double)0.7f;
        if (!this.isRandom) {
            this.xd = 0.0;
            this.zd = 0.0;
        } else {
            this.xd += (double)this.random.nextFloat() * 0.1 + (double)0.1f;
            this.zd += (double)this.random.nextFloat() * 0.1 + (double)0.1f;
        }
        this.orientTowardsVelocity = (quaternion, camera, partialTick) -> {
            Vector3f velocityDir = new Vector3f((float)this.xd, (float)this.yd, (float)this.zd).normalize();
            quaternion.identity();
            quaternion.rotateX(1.5707964f);
            quaternion.lookAlong((Vector3fc)velocityDir, (Vector3fc)camera.getLookVector()).conjugate();
        };
    }

    @NotNull
    private Vector4f getTintColor() {
        return ColorUtils.convertToRGBAVec(this.isFools() ? ColorUtils.HSBtoFRGB((float)((System.currentTimeMillis() + (long)this.random.nextInt(10000)) % 10000L) / 10000.0f, 1.0f, 1.0f) : this.clientFluid.getTintColor(Fluids.WATER.defaultFluidState(), (BlockAndTintGetter)this.level, new BlockPos((int)this.x, (int)this.y, (int)this.z)));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return this.alpha > 0.95f ? ParticleRenderType.PARTICLE_SHEET_OPAQUE : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private boolean isFools() {
        return SimpleWeatherClient.IsFools;
    }

    public void tick() {
        super.tick();
        if (this.lifetime == 0) {
            return;
        }
        if ((float)this.age / (float)this.lifetime > 0.7f) {
            this.scale(0.9f);
        }
        this.pos.set(this.x, this.y, this.z);
        if (this.y == this.yo || this.onGround || this.level.isFluidAtPosition((BlockPos)this.pos, Predicate.not(FluidState::isEmpty))) {
            this.handleRainCollision();
        }
        if (this.isRandom && this.random.nextFloat() < 0.1f) {
            this.xd *= 1.05;
            this.zd *= (double)1.05f;
            this.yd *= (double)0.95f;
        }
        if (this.isFools() || this.age % 4 != 0) {
            return;
        }
        this.color.set((Vector4fc)this.getTintColor());
        this.color.mul(0.8f);
    }

    private void handleRainCollision() {
        if (this.random.nextInt(0, 100) <= (Integer)SimpleWeather.ClientConfig.RainCollisionPercent.get()) {
            this.level.addParticle((ParticleOptions)ParticleTypes.RAIN, this.x, this.y + 0.25, this.z, 0.0, 0.0, 0.0);
        }
        this.remove();
    }

    public void render(@NotNull VertexConsumer consumer, @NotNull Camera camera, float partialTick) {
        super.render(consumer, camera, partialTick);
        if (this.isFools()) {
            return;
        }
        Vector4f lerped = this.prevColor.lerp((Vector4fc)this.color, partialTick * 0.01f);
        this.rCol = lerped.x;
        this.gCol = lerped.y;
        this.bCol = lerped.z;
    }

    public boolean shouldCull() {
        return false;
    }

    @NotNull
    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return this.orientTowardsVelocity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(@NotNull SimpleParticleType type, ClientLevel level, double xo, double yo, double zo, double ignored1, double ignored2, double ignored3) {
            RandomSource randomsource = level.random;
            double vx = (double)randomsource.nextFloat() * -1.9 * (double)randomsource.nextFloat() * 0.1 + ignored1;
            double vy = (double)randomsource.nextFloat() * -0.5 * (double)randomsource.nextFloat() * 0.5 + ignored2;
            double vz = (double)randomsource.nextFloat() * -1.9 * (double)randomsource.nextFloat() * 0.1 + ignored3;
            return new RainParticle(level, xo, yo, zo, vx, vy, vz, 1.0f, this.sprites);
        }
    }
}

