/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.ImageButtonAccessor;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfigData;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import org.jetbrains.annotations.Nullable;

public class CraftingGuideButtonFixer {
    public static Button fixMistakes(AbstractContainerScreen<?> screen) {
        Button button = CraftingGuideButtonFixer.findCraftButton(((ScreenAccessor)screen).balm_getChildren());
        if (button != null) {
            CraftingTweaksConfigData config = CraftingTweaksConfig.getActive();
            if (config.client.hideVanillaCraftingGuide) {
                button.visible = false;
            } else if (!(screen instanceof InventoryScreen)) {
                AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)screen;
                button.setX(accessor.getLeftPos() + accessor.getImageWidth() - 25);
                if (screen.getClass().getSimpleName().equals("GuiCraftingStation")) {
                    button.setY(accessor.getTopPos() + 37);
                } else {
                    button.setY(accessor.getTopPos() + 5);
                }
                if (Balm.isModLoaded((String)"inventorytweaks")) {
                    button.setX(button.getX() - 15);
                }
            }
        }
        return button;
    }

    @Nullable
    private static Button findCraftButton(List<? extends GuiEventListener> buttonList) {
        return buttonList.stream().filter(p -> {
            ImageButtonAccessor imageButton;
            return p instanceof ImageButtonAccessor && (imageButton = (ImageButtonAccessor)p).getSprites().get(false, false).getPath().equals("recipe_book/button");
        }).findFirst().orElse(null);
    }
}

