/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.api;

import net.blay09.mods.craftingtweaks.api.CraftingTweaksDefaultHandlers;
import net.blay09.mods.craftingtweaks.api.GridBalanceHandler;
import net.blay09.mods.craftingtweaks.api.GridClearHandler;
import net.blay09.mods.craftingtweaks.api.GridRotateHandler;
import net.blay09.mods.craftingtweaks.api.GridTransferHandler;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public interface CraftingGrid {
    public ResourceLocation getId();

    default public Container getCraftingMatrix(Player player, AbstractContainerMenu menu) {
        return ((Slot)menu.slots.get((int)this.getGridStartSlot((Player)player, (AbstractContainerMenu)menu))).container;
    }

    default public int getGridStartSlot(Player player, AbstractContainerMenu menu) {
        return 1;
    }

    default public int getGridSize(Player player, AbstractContainerMenu menu) {
        return 9;
    }

    default public boolean isTweakActive(TweakType tweak) {
        return true;
    }

    default public GridTransferHandler<AbstractContainerMenu> transferHandler() {
        return CraftingTweaksDefaultHandlers.defaultTransferHandler();
    }

    default public GridRotateHandler<AbstractContainerMenu> rotateHandler() {
        return CraftingTweaksDefaultHandlers.defaultRectangularRotateHandler();
    }

    default public GridClearHandler<AbstractContainerMenu> clearHandler() {
        return CraftingTweaksDefaultHandlers.defaultClearHandler();
    }

    default public GridBalanceHandler<AbstractContainerMenu> balanceHandler() {
        return CraftingTweaksDefaultHandlers.defaultBalanceHandler();
    }
}

