/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange;

import dev.architectury.platform.Platform;
import java.nio.file.Path;
import net.creeperhost.equivalentexchange.api.EquivalentExchangeAPI;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Range;

public class Constants {
    public static final String MOD_ID = "equivalentexchange";
    public static final Path EE_CONFIG_FOLDER = Platform.getConfigFolder().resolve("equivalentexchange");
    public static final Path EE_CONFIG_FILE = EE_CONFIG_FOLDER.resolve("equivalentexchange.json");
    public static final String SHIFT_TEXT = "tooltip.equivalentexchange.hold_shift";
    public static final double MAX_EMC = 118.0;

    public static @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long getEMCPerDurability(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0L;
        }
        if (stack.isDamageableItem()) {
            ItemStack stackCopy = stack.copy();
            stackCopy.setDamageValue(0);
            long emc = (long)Math.ceil(EquivalentExchangeAPI.getEmcValue(stackCopy) / (double)stack.getMaxDamage());
            return Math.max(emc, 1L);
        }
        return 1L;
    }
}

