/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.equivalentexchange;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import net.creeperhost.equivalentexchange.Constants;
import net.creeperhost.equivalentexchange.EquivalentExchangeClient;
import net.creeperhost.equivalentexchange.api.events.EmcRegisterEvent;
import net.creeperhost.equivalentexchange.compat.CompatHandler;
import net.creeperhost.equivalentexchange.config.EE3ConfigData;
import net.creeperhost.equivalentexchange.dynemc.DynamicEmc;
import net.creeperhost.equivalentexchange.dynemc.special.ConcreteHandler;
import net.creeperhost.equivalentexchange.init.ModBlocks;
import net.creeperhost.equivalentexchange.init.ModContainers;
import net.creeperhost.equivalentexchange.init.ModCreativeTabs;
import net.creeperhost.equivalentexchange.init.ModEntities;
import net.creeperhost.equivalentexchange.init.ModItems;
import net.creeperhost.equivalentexchange.init.ModRecipes;
import net.creeperhost.equivalentexchange.init.ModSounds;
import net.creeperhost.equivalentexchange.network.PacketHandler;
import net.creeperhost.equivalentexchange.server.ServerEvents;
import net.creeperhost.equivalentexchange.server.commands.EECommands;
import net.creeperhost.polylib.config.ConfigBuilder;
import net.creeperhost.polylib.config.ConfigData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EquivalentExchange {
    public static Logger LOGGER = LogManager.getLogger();
    public static ConfigBuilder CONFIG_BUILDER;
    public static EE3ConfigData CONFIG_DATA;

    public static void init() {
        EquivalentExchange.setupConfigs();
        CompatHandler.init();
        DynamicEmc.init();
        ModBlocks.BLOCKS.register();
        ModBlocks.TILES_ENTITIES.register();
        ModItems.ITEMS.register();
        ModCreativeTabs.CREATIVE_MODE_TABS.register();
        ModContainers.CONTAINERS.register();
        ModSounds.SOUNDS.register();
        ModRecipes.RECIPE_SERIALIZERS.register();
        ModEntities.ENTITY_TYPES.register();
        ModRecipes.init();
        PacketHandler.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            EquivalentExchangeClient.init();
        }
        CommandRegistrationEvent.EVENT.register(EECommands::registerCommand);
        PlayerEvent.PLAYER_JOIN.register(ServerEvents::onPlayerJoin);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(ServerEvents::onLevelSave);
        LifecycleEvent.SERVER_STOPPED.register(ServerEvents::onServerStop);
        LifecycleEvent.SERVER_STARTED.register(server -> ModItems.registerFuelValues());
        LifecycleEvent.SERVER_LEVEL_LOAD.register(ServerEvents::onServerLoad);
        EmcRegisterEvent.EMC_PRE_START.register(resourceManager -> ConcreteHandler.init());
        EmcRegisterEvent.EMC_POST_START.register(resourceManager -> ConcreteHandler.init());
    }

    public static void setupConfigs() {
        boolean created;
        if (!Constants.EE_CONFIG_FOLDER.toFile().exists() && (created = Constants.EE_CONFIG_FOLDER.toFile().mkdirs())) {
            LOGGER.info("Created equivalentexchange Config folder");
        }
        CONFIG_BUILDER = new ConfigBuilder("equivalentexchange", Constants.EE_CONFIG_FILE, (ConfigData)new EE3ConfigData());
        CONFIG_DATA = (EE3ConfigData)CONFIG_BUILDER.getConfigData();
    }
}

